/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeToMeasureColumn;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeTypeRollbackableWorker;
import org.gcube.data.analysis.tabulardata.operation.datatype.TypeTransitionSQLHandler;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public class ChangeToMeasureColumnFactory
extends ChangeColumnTypeTransformationFactory {
    private static final ColumnType MANAGED_COLUMN_TYPE = new MeasureColumnType();
    private static final OperationId OPERATION_ID = new OperationId(2002L);
    public static final List<ColumnType> allowedSourceColumnTypes = Lists.newArrayList();
    private DatabaseConnectionProvider connectionProvider;
    private CubeManager cubeManager;
    private WorkerFactory<ValidationWorker> fallbackFactory;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private static final List<Parameter> parameters = new ArrayList<Parameter>();

    @Inject
    public ChangeToMeasureColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, ColumnTypeCastValidatorFactory fallbackFactory, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.fallbackFactory = fallbackFactory;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    @Override
    protected ColumnType getManagedColumnType() {
        return MANAGED_COLUMN_TYPE;
    }

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnTypeTransition(invocation, this.cubeManager);
        this.checkTypeTransformationEligibility(invocation);
        return new ChangeToMeasureColumn(invocation, this.cubeManager, this.connectionProvider, this.sqlEvaluatorFactory);
    }

    public boolean isRollbackable() {
        return true;
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new ChangeTypeRollbackableWorker(diffTable, createdTable, oldInvocation, this.cubeManager, this.connectionProvider);
    }

    private void checkTypeTransformationEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        DataType newDataType;
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Column targetColumn = targetTable.getColumnById(invocation.getTargetColumnId());
        DataType sourceDataType = targetColumn.getDataType();
        if (TypeTransitionSQLHandler.isSupportedTransition(sourceDataType, newDataType = (DataType)OperationHelper.getParameter((LeafParameter)ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER, (OperationInvocation)invocation), this.sqlEvaluatorFactory)) {
            return;
        }
        throw new InvalidInvocationException(invocation, String.format("Unable to transform a %s column into a %s column", sourceDataType.getName(), newDataType.getName()));
    }

    @Override
    protected List<ColumnType> getAllowedSourceColumnTypes() {
        return allowedSourceColumnTypes;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public List<WorkerFactory<ValidationWorker>> getPrecoditionValidations() {
        return Collections.singletonList(this.fallbackFactory);
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnTypeTransition(invocation, this.cubeManager);
        this.checkTypeTransformationEligibility(invocation);
        Column targetColumn = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(invocation.getTargetColumnId());
        DataType dataType = (DataType)OperationHelper.getParameter((LeafParameter)ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER, (OperationInvocation)invocation);
        return String.format("Set %s as %s [%s]", OperationHelper.retrieveColumnLabel((Column)targetColumn), this.getManagedColumnType().getName(), dataType);
    }

    static {
        allowedSourceColumnTypes.add((ColumnType)new AnnotationColumnType());
        allowedSourceColumnTypes.add((ColumnType)new AttributeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeNameColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeDescriptionColumnType());
        allowedSourceColumnTypes.add((ColumnType)new MeasureColumnType());
        ArrayList<Class> allowedDataTypes = new ArrayList<Class>();
        allowedDataTypes.add(IntegerType.class);
        allowedDataTypes.add(NumericType.class);
        parameters.add((Parameter)ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER);
        parameters.add((Parameter)ColumnTypeCastValidatorFactory.FORMAT_ID_PARAMETER);
        parameters.add((Parameter)ADDITIONAL_META_PARAMETER);
    }
}

