/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeToTimeDimensionColumn;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeTypeRollbackableWorker;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelperProvider;
import org.gcube.data.analysis.tabulardata.operation.validation.TimeDimensionColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

@Singleton
public class ChangeToTimeDimensionColumnFactory
extends ChangeColumnTypeTransformationFactory {
    private static final ColumnType MANAGED_COLUMN_TYPE = new TimeDimensionColumnType();
    private static final OperationId OPERATION_ID = new OperationId(2007L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private static final List<ColumnType> allowedSourceColumnTypes = Lists.newArrayList();
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private WorkerFactory<ValidationWorker> fallbackFactory;
    private PeriodTypeHelperProvider periodTypeHelperProvider;
    private SQLExpressionEvaluatorFactory evaluator;

    static {
        allowedSourceColumnTypes.add((ColumnType)new CodeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeNameColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeDescriptionColumnType());
        allowedSourceColumnTypes.add((ColumnType)new AttributeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new AnnotationColumnType());
        parameters.add((Parameter)TimeDimensionColumnValidatorFactory.PERIOD_FORMAT_PARAMETER);
        parameters.add((Parameter)TimeDimensionColumnValidatorFactory.FORMAT_ID_PARAMETER);
    }

    @Inject
    public ChangeToTimeDimensionColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, TimeDimensionColumnValidatorFactory fallbackFactory, PeriodTypeHelperProvider periodTypeHelperProvider, SQLExpressionEvaluatorFactory evaluator) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.fallbackFactory = fallbackFactory;
        this.periodTypeHelperProvider = periodTypeHelperProvider;
        this.evaluator = evaluator;
    }

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnTypeTransition(invocation, this.cubeManager);
        this.checkTargetColumnEligibility(invocation);
        return new ChangeToTimeDimensionColumn(invocation, this.cubeManager, this.connectionProvider, this.periodTypeHelperProvider, this.evaluator);
    }

    public boolean isRollbackable() {
        return true;
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new ChangeTypeRollbackableWorker(diffTable, createdTable, oldInvocation, this.cubeManager, this.connectionProvider);
    }

    private void checkTargetColumnEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Column column = targetTable.getColumnById(invocation.getTargetColumnId());
        if (!(column.getDataType() instanceof TextType)) {
            throw new InvalidInvocationException(invocation, "A text type column is needed in order to perform time dimension transformation");
        }
    }

    @Override
    protected ColumnType getManagedColumnType() {
        return MANAGED_COLUMN_TYPE;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public List<WorkerFactory<ValidationWorker>> getPrecoditionValidations() {
        return Collections.singletonList(this.fallbackFactory);
    }

    @Override
    protected List<ColumnType> getAllowedSourceColumnTypes() {
        return allowedSourceColumnTypes;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnTypeTransition(invocation, this.cubeManager);
        this.checkTargetColumnEligibility(invocation);
        Column targetColumn = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(invocation.getTargetColumnId());
        String timePeriodFormat = (String)OperationHelper.getParameter((LeafParameter)TimeDimensionColumnValidatorFactory.PERIOD_FORMAT_PARAMETER, (OperationInvocation)invocation);
        return String.format("Set %s as %s [%s]", OperationHelper.retrieveColumnLabel((Column)targetColumn), this.getManagedColumnType().getName(), timePeriodFormat);
    }
}

