/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.harmonization.HarmonizationRule;
import org.gcube.data.analysis.tabulardata.model.metadata.table.HarmonizationRuleTable;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Harmonizations {
    private static final Logger log = LoggerFactory.getLogger(ValidateDataWithExpression.class);

    public static void harmonizeTable(HarmonizationRuleTable rules, ColumnReference referredCodelistColumn, ColumnReference toHarmonize, Table toHarmonizeTable, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rsRule = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            String conditionValue = (String)sqlEvaluatorFactory.getEvaluator((Expression)new TDText(referredCodelistColumn.getColumnId().getValue())).evaluate();
            String getRulesQuery = "SELECT * FROM " + rules.getRulesTable().getName() + " WHERE " + "referred_column" + " = " + conditionValue;
            log.debug("Rule query is " + getRulesQuery);
            rsRule = stmt.executeQuery(getRulesQuery);
            ArrayList<String> updateCommands = new ArrayList<String>();
            ResultSetMetaData rsMeta = rsRule.getMetaData();
            while (rsRule.next()) {
                try {
                    HarmonizationRule rule = Harmonizations.getRule(rsRule, rsMeta);
                    updateCommands.add(Harmonizations.getRuleSqlCommand(rule, toHarmonize, toHarmonizeTable, sqlEvaluatorFactory));
                }
                catch (Exception e) {
                    log.error(String.format("Skipping invalid rule [ID : %s, table :]", rsRule.getString("id"), rules.getRulesTable().getName()), (Throwable)e);
                }
            }
            log.debug("Applying " + updateCommands.size() + " rules on " + toHarmonize);
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)connectionProvider, (String[])updateCommands.toArray(new String[updateCommands.size()]));
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rsRule);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rsRule);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
    }

    public static HarmonizationRule getRule(ResultSet rs, ResultSetMetaData rsMeta) throws JAXBException, SQLException {
        HashMap<String, String> fields = new HashMap<String, String>();
        int i = 1;
        while (i <= rsMeta.getColumnCount()) {
            fields.put(rsMeta.getColumnName(i), rs.getString(i));
            ++i;
        }
        return new HarmonizationRule(fields);
    }

    public static String getRuleSqlCommand(HarmonizationRule rule, ColumnReference targetColumn, Table targetTable, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        String targetColumnName = targetTable.getColumnById(targetColumn.getColumnId()).getName();
        String toSetValue = (String)sqlEvaluatorFactory.getEvaluator((Expression)rule.getToSetValue()).evaluate();
        String condition = (String)sqlEvaluatorFactory.getEvaluator((Expression)new Equals((Expression)targetColumn, (Expression)rule.getToChangeValue())).evaluate();
        return String.format("UPDATE %s SET %s = %s WHERE %s", targetTable.getName(), targetColumnName, toSetValue, condition);
    }

    public static boolean isColumnUnderRules(ColumnLocalId referredColumnId, HarmonizationRuleTable table, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) throws SQLException {
        boolean bl;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            String conditionValue = (String)sqlEvaluatorFactory.getEvaluator((Expression)new TDText(referredColumnId.toString())).evaluate();
            bl = stmt.execute("SELECT * FROM " + table.getRulesTable().getName() + " WHERE " + "referred_column" + " = " + conditionValue + " OFFSET 0 LIMIT 1");
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(stmt);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return bl;
    }
}

