/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.security;

import java.security.Key;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.soap.SOAPFaultException;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.operation.sdmx.security.Credentials;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISManager {
    private final String CATEGORY = "Category";
    private final String SDMX = "SDMX";
    private final String NAME = "Name";
    private final String REGISTRY = "SDMXRegistry";
    private final String ENDPOINT = "AccessPoint/Interface/Endpoint";
    private final String RESULTS = "$resource/Profile/AccessPoint";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<ServiceEndpoint.AccessPoint> getAccessPoints(String endpoint) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        String queryCondition1 = this.generateQuery("Category", "SDMX");
        this.logger.debug("Query condition 1: " + queryCondition1);
        String queryCondition2 = this.generateQuery("Name", "SDMXRegistry");
        this.logger.debug("Query condition 2: " + queryCondition2);
        String endpointCondition = this.generateQuery("AccessPoint/Interface/Endpoint", endpoint.trim());
        this.logger.debug("Endpoint condition: " + endpointCondition);
        query.addCondition(queryCondition1);
        query.addCondition(queryCondition2);
        query.addCondition(endpointCondition);
        query.setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        List response = client.submit((Query)query);
        return response;
    }

    public Credentials getCredentials(String endpoint, String protocol) {
        this.logger.debug("Getting access points list for " + endpoint + " and protocol " + protocol);
        List<ServiceEndpoint.AccessPoint> accessPoints = this.getAccessPoints(endpoint);
        Credentials response = new Credentials(null, null);
        if (accessPoints == null) {
            this.logger.warn("No access point found on IS!!!");
        } else {
            boolean found = false;
            Iterator<ServiceEndpoint.AccessPoint> accessPointIterator = accessPoints.iterator();
            while (accessPointIterator.hasNext() && !found) {
                ServiceEndpoint.AccessPoint accessPoint = accessPointIterator.next();
                String accessPointProtocol = accessPoint.name();
                this.logger.debug("Access point for " + accessPointProtocol);
                if (!protocol.equalsIgnoreCase(accessPointProtocol)) continue;
                this.logger.debug("Protocol found");
                found = true;
                String userName = accessPoint.username();
                this.logger.debug("Username " + userName);
                if (userName != null && userName.trim().length() > 0) {
                    this.logger.debug("Credentials found");
                    try {
                        response = new Credentials(userName, this.decryptPassword(accessPoint.password()));
                    }
                    catch (Exception e) {
                        this.logger.error("Unable to decrypt password", (Throwable)e);
                    }
                    continue;
                }
                this.logger.debug("Credentials not present");
            }
            if (!found) {
                this.logger.warn("Credentials not found for the selected protocol");
            }
        }
        return response;
    }

    private String decryptPassword(String originalPassword) throws Exception {
        this.logger.debug("Encrypted password " + originalPassword);
        String response = StringEncrypter.getEncrypter().decrypt(originalPassword, new Key[0]);
        return response;
    }

    private String generateQuery(String element, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("$resource/Profile/");
        builder.append(element).append("/text() eq '");
        builder.append(name);
        builder.append("'");
        return builder.toString();
    }

    public static void main(String[] args) {
        ScopeProvider.instance.set("/gcube/devNext/NextNext");
        try {
            List<ServiceEndpoint.AccessPoint> aps = new ISManager().getAccessPoints("http://node8.d.d4science.research-infrastructures.eu:8080/FusionRegistry/ws/rest/");
            for (ServiceEndpoint.AccessPoint ap : aps) {
                System.out.println(ap.address());
                System.out.println(ap.name());
                System.out.println(ap.username());
                System.out.println(ap.password());
                System.out.println("********************");
            }
        }
        catch (RuntimeException e) {
            SOAPFaultException soap = (SOAPFaultException)e.getCause();
            System.out.println(soap.getMessage());
            System.out.println(soap.getFault());
        }
    }
}

