/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.template;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.data.analysis.tabulardata.commons.templates.model.ReferenceObject;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.utils.DimensionReference;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.SDMXResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.codelist.SDMXCodelistGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.ExcelGeneratorFromTemplate;
import org.gcube.data.analysis.tabulardata.operation.sdmx.security.Credentials;
import org.gcube.data.analysis.tabulardata.operation.sdmx.template.TemplateWorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.template.conceptscheme.SDMXConceptSchemeGeneratorFromTemplate;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableSDMXResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXVersionException;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.RepresentationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataflowMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.PrimaryMeasureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.RepresentationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.AttributeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DataStructureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.PrimaryMeasureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.DataflowMutableBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXTemplateExporter
extends ResourceCreatorWorker {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Template template;
    private List<TemplateColumn<?>> templateColumns;
    private TemplateColumn<?> primaryMeasure;
    private OperationInvocation invocation;
    private String registryUrl;
    private String targetAgency;
    private String targetId;
    private String targetVersion;
    private CubeManager cubeManager;
    private final String ATTRIBUTE_ASSIGNMENT_STATUS_MANDATORY = "Mandatory";
    private static String errorMessage = "Unable to complete export procedure";
    private DatabaseConnectionProvider connectionProvider;
    private SDMXConceptSchemeGeneratorFromTemplate conceptSchemeGenerator;
    private String username;
    private String password;
    private boolean excel;

    public SDMXTemplateExporter(Template template, DatabaseConnectionProvider connectionProvider, OperationInvocation invocation, CubeManager cubeManager) {
        super(invocation);
        this.template = template;
        this.invocation = invocation;
        this.connectionProvider = connectionProvider;
        this.cubeManager = cubeManager;
        this.username = null;
        this.password = null;
        this.log.debug("Worker instantiated");
    }

    protected ResourcesResult execute() throws WorkerException {
        try {
            this.log.debug("Execution");
            this.init();
            this.updateProgress(0.1f, "Creating beans");
            DataStructureMutableBean dataStructure = this.createDataStructureBean();
            ConceptSchemeMutableBean conceptScheme = this.conceptSchemeGenerator.createConceptSchemeBean();
            DataflowMutableBean dataFlow = this.createDataFlowBean(dataStructure);
            this.updateProgress(0.2f, "Populating data structure");
            HashSet<CodelistBean> codelists = new HashSet<CodelistBean>();
            this.populateDataStructure(dataStructure, conceptScheme, codelists);
            this.updateProgress(0.6f, "Publishing");
            this.publishData(dataStructure, conceptScheme, dataFlow, codelists);
            if (this.excel) {
                this.updateProgress(0.8f, "Generating excel");
                this.generateExcel();
            }
            this.updateProgress(0.9f, "Finalizing");
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableSDMXResource(new SDMXResource(new URL(this.registryUrl), this.targetId, this.targetVersion, this.targetAgency, SDMXResource.TYPE.CODE_LIST), "Codelist SDMX export", String.format("%s/%s/%s/%s/", this.registryUrl, this.targetAgency, this.targetId, this.targetVersion), ResourceType.SDMX));
        }
        catch (RuntimeException e) {
            this.log.debug("Runtime exception", (Throwable)e);
            this.log.error(errorMessage, (Throwable)e);
            throw new WorkerException(errorMessage, (Throwable)e);
        }
        catch (MalformedURLException e) {
            this.log.debug("URL exception", (Throwable)e);
            throw new WorkerException(String.format("exported url %s not valid", this.registryUrl), (Throwable)e);
        }
    }

    private void init() {
        this.log.debug("Init internal variables");
        this.templateColumns = new ArrayList(this.template.getActualStructure());
        this.registryUrl = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        this.targetAgency = (String)this.invocation.getParameterInstances().get("agency");
        this.targetId = (String)this.invocation.getParameterInstances().get("id");
        this.targetVersion = (String)this.invocation.getParameterInstances().get("version");
        Credentials credentials = WorkerUtils.retrieveCredentials(this.registryUrl);
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
        String observationValue = (String)this.invocation.getParameterInstances().get("obsValueColumn");
        this.primaryMeasure = this.getPrimaryMeasure(observationValue);
        Boolean excelObject = (Boolean)this.invocation.getParameterInstances().get("excel");
        this.excel = excelObject != null && excelObject != false;
        this.conceptSchemeGenerator = new SDMXConceptSchemeGeneratorFromTemplate(this.template, this.targetId, this.targetAgency, this.targetVersion);
    }

    private TemplateColumn<?> getPrimaryMeasure(String observationValue) {
        this.log.debug("Loading primary measure");
        this.log.debug("For obs value " + observationValue);
        int size = this.templateColumns.size();
        TemplateColumn<?> response = null;
        int i = 0;
        while (response == null && i < size) {
            TemplateColumn<?> templateColumn = this.templateColumns.get(i);
            String columnID = templateColumn.getId();
            ColumnCategory columnType = templateColumn.getColumnType();
            this.log.debug("Column label " + templateColumn.getLabel());
            this.log.debug("Column label " + templateColumn.getId());
            this.log.debug("Column type " + columnType);
            if (columnType == ColumnCategory.MEASURE && columnID.equals(observationValue)) {
                this.log.debug("Primary measure found");
                response = this.templateColumns.remove(i);
            }
            ++i;
        }
        return response;
    }

    private void publishData(DataStructureMutableBean dsd, ConceptSchemeMutableBean concepts, DataflowMutableBean dataFlow, Set<CodelistBean> associatedCodelists) throws WorkerException {
        String url = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        SDMXRegistryClient registryClient = TemplateWorkerUtils.initSDMXClient(url, this.username, this.password);
        String currentType = null;
        try {
            this.log.debug("Publishing associated codelists...");
            currentType = "codelists";
            for (CodelistBean codelist : associatedCodelists) {
                this.log.debug("Publishing codelist " + codelist.getId());
                try {
                    registryClient.publish(codelist);
                    this.log.debug("Codelist published");
                }
                catch (SDMXVersionException versionException) {
                    this.log.debug("Codelist already present at a version >= of the used one: " + versionException.getMessage());
                    this.log.debug("Codelist not published, the present one will be used");
                }
            }
            try {
                currentType = "concepts";
                this.log.debug("Publishing concepts...");
                registryClient.publish(concepts.getImmutableInstance());
                this.log.debug("Concepts published");
                currentType = "data structure definitions";
                this.log.debug("Publishing dsd...");
                registryClient.publish(dsd.getImmutableInstance());
                this.log.debug("DSD published");
                currentType = "data flow";
                this.log.debug("Publishing data flow...");
                registryClient.publish(dataFlow.getImmutableInstance());
                this.log.debug("Data flow published");
            }
            catch (SDMXVersionException e) {
                this.log.error("Error in the pubblication", (Throwable)e);
                throw new WorkerException(e.getMessage(), (Throwable)e);
            }
        }
        catch (SDMXRegistryClientException e) {
            this.log.error("Client exception", (Throwable)e);
            throw new WorkerException("Unable to publish dsd on registry: error in the" + currentType, (Throwable)e);
        }
    }

    private TemplateColumn<?> getColumnsByType(List<TemplateColumn<?>> measureColumns, List<TemplateColumn<?>> dimensionColumns, List<TemplateColumn<?>> attributeColumns) {
        this.log.debug("Classifying columns per type");
        TemplateColumn<?> timeDimension = null;
        for (TemplateColumn<?> templateColumn : this.templateColumns) {
            ColumnCategory columnType = templateColumn.getColumnType();
            switch (columnType) {
                case ATTRIBUTE: {
                    this.log.debug("Attribute");
                    attributeColumns.add(templateColumn);
                    break;
                }
                case TIMEDIMENSION: {
                    this.log.debug("Time dimension");
                    timeDimension = templateColumn;
                    break;
                }
                case MEASURE: {
                    this.log.debug("Measure");
                    measureColumns.add(templateColumn);
                    break;
                }
                case DIMENSION: {
                    this.log.debug("Dimension");
                    dimensionColumns.add(templateColumn);
                }
            }
        }
        return timeDimension;
    }

    private void generateExcel() {
        this.log.debug("Generating excel");
        ExcelGeneratorFromTemplate generator = new ExcelGeneratorFromTemplate(this.template);
        this.log.debug("Generator created");
        this.log.debug("Target id " + this.targetId);
        generator.generateExcel(String.valueOf(this.targetId) + "_" + this.targetVersion, "sdmx");
        this.log.debug("Operation completed");
    }

    private void populateDataStructure(DataStructureMutableBean dataStructure, ConceptSchemeMutableBean conceptScheme, Set<CodelistBean> codelists) throws WorkerException {
        this.log.debug("Loading column data");
        ArrayList measureColumns = new ArrayList();
        ArrayList dimensionColumns = new ArrayList();
        ArrayList attributeColumns = new ArrayList();
        TemplateColumn<?> timeDimensionColumn = this.getColumnsByType(measureColumns, dimensionColumns, attributeColumns);
        this.log.debug("Columns loaded");
        ConceptMutableBean primaryMeasureConcept = this.conceptSchemeGenerator.createConceptBean(this.primaryMeasure);
        conceptScheme.addItem((ItemMutableBean)primaryMeasureConcept);
        StructureReferenceBeanImpl conceptReferenceBean = new StructureReferenceBeanImpl(primaryMeasureConcept.getParentAgency(), conceptScheme.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{primaryMeasureConcept.getId()});
        PrimaryMeasureMutableBeanImpl primaryMeasureBean = new PrimaryMeasureMutableBeanImpl();
        primaryMeasureBean.setConceptRef((StructureReferenceBean)conceptReferenceBean);
        primaryMeasureBean.setId("OBS_VALUE");
        dataStructure.setPrimaryMeasure((PrimaryMeasureMutableBean)primaryMeasureBean);
        this.addMeasureDimensions(dataStructure, measureColumns, conceptScheme);
        this.addGenericDimensions(dataStructure, dimensionColumns, conceptScheme, codelists);
        DimensionMutableBeanImpl timeDimensionBean = new DimensionMutableBeanImpl();
        timeDimensionBean.setId("TIME_PERIOD");
        ConceptMutableBean timeDimensionConcept = this.conceptSchemeGenerator.createConceptBean(timeDimensionColumn);
        conceptScheme.addItem((ItemMutableBean)timeDimensionConcept);
        timeDimensionBean.setConceptRef(this.getConceptReference(conceptScheme, timeDimensionConcept));
        timeDimensionBean.setTimeDimension(true);
        dataStructure.addDimension((DimensionMutableBean)timeDimensionBean);
        this.addAttributes(dataStructure, attributeColumns, conceptScheme, codelists);
    }

    private void addGenericDimensions(DataStructureMutableBean dsd, List<TemplateColumn<?>> dimensionColumns, ConceptSchemeMutableBean concepts, Set<CodelistBean> codelists) {
        this.log.debug("Adding dimension list bean");
        for (TemplateColumn<?> column : dimensionColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            RepresentationMutableBean codedRepresentation = this.createCodeListRepresentation(column, codelists);
            if (codedRepresentation != null) {
                this.log.debug("Found a code list representation");
                columnConcept.setCoreRepresentation(codedRepresentation);
            }
            StructureReferenceBean conceptsReference = this.getConceptReference(concepts, columnConcept);
            DimensionMutableBeanImpl dimension = new DimensionMutableBeanImpl();
            dimension.setId(String.valueOf(this.formatLabel(column.getLabel())) + "_DSD");
            dimension.setConceptRef(conceptsReference);
            dsd.addDimension((DimensionMutableBean)dimension);
        }
    }

    private String formatLabel(String label) {
        String response = null;
        if (label != null) {
            response = label.trim().replace(' ', '_');
        }
        return response;
    }

    private void addAttributes(DataStructureMutableBean dataStructure, List<TemplateColumn<?>> attributeColumns, ConceptSchemeMutableBean concepts, Set<CodelistBean> codelists) {
        this.log.debug("Adding attribute list bean");
        for (TemplateColumn<?> column : attributeColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            AttributeMutableBeanImpl attributeBean = new AttributeMutableBeanImpl();
            attributeBean.setAttachmentLevel(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION);
            attributeBean.setAssignmentStatus("Mandatory");
            RepresentationMutableBean codedRepresentation = this.createCodeListRepresentation(column, codelists);
            if (codedRepresentation != null) {
                this.log.debug("Found a code list representation");
                columnConcept.setCoreRepresentation(codedRepresentation);
            }
            attributeBean.setConceptRef(this.getConceptReference(concepts, columnConcept));
            dataStructure.addAttribute((AttributeMutableBean)attributeBean);
        }
    }

    private void addMeasureDimensions(DataStructureMutableBean dsd, List<TemplateColumn<?>> measureColumns, ConceptSchemeMutableBean concepts) {
        this.log.debug("Adding measure dimension list bean");
        for (TemplateColumn<?> column : measureColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            DimensionMutableBeanImpl dimensionBean = new DimensionMutableBeanImpl();
            dimensionBean.setMeasureDimension(true);
            dimensionBean.setConceptRef(this.getConceptReference(concepts, columnConcept));
            dsd.addDimension((DimensionMutableBean)dimensionBean);
        }
    }

    private StructureReferenceBean getConceptReference(ConceptSchemeMutableBean conceptScheme, ConceptMutableBean concept) {
        this.log.debug("Creating reference for concept " + concept.getId());
        return new StructureReferenceBeanImpl(concept.getParentAgency(), conceptScheme.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{concept.getId()});
    }

    private RepresentationMutableBean createCodeListRepresentation(TemplateColumn<?> column, Set<CodelistBean> codelists) {
        this.log.debug("Creating codelist bean");
        RepresentationMutableBeanImpl response = null;
        Table codelist = this.getAssociatedCodelist(column);
        if (codelist != null) {
            this.log.debug("Table found " + codelist.getName());
            SDMXCodelistGenerator codeListGenerator = new SDMXCodelistGenerator(codelist, this.connectionProvider, this.targetAgency, String.valueOf(codelist.getName()) + "_CL", this.targetVersion);
            CodelistMutableBean codeListBean = codeListGenerator.createBaseCodelistBean();
            try {
                codeListGenerator.populateCodelistWithCodes(codeListBean);
                CodelistBean immutableCodelist = codeListBean.getImmutableInstance();
                codelists.add(immutableCodelist);
                response = new RepresentationMutableBeanImpl();
                response.setRepresentation((StructureReferenceBean)new StructureReferenceBeanImpl((IdentifiableBean)immutableCodelist));
            }
            catch (Exception e) {
                this.log.warn("Codelist not loaded", (Throwable)e);
            }
        }
        return response;
    }

    private DataStructureMutableBean createDataStructureBean() {
        DataStructureMutableBeanImpl dataStructure = new DataStructureMutableBeanImpl();
        dataStructure.setAgencyId(this.targetAgency);
        dataStructure.setVersion(this.targetVersion);
        String dsdId = String.valueOf(this.targetId) + "_DSD";
        dataStructure.setId(dsdId);
        dataStructure.addName("en", String.valueOf(this.targetId) + " Data Structure");
        return dataStructure;
    }

    private DataflowMutableBean createDataFlowBean(DataStructureMutableBean dataStructure) {
        DataflowMutableBeanImpl dataFlow = new DataflowMutableBeanImpl();
        this.log.debug("Populating data flow bean");
        dataFlow.setAgencyId(this.targetAgency);
        dataFlow.setDataStructureRef((StructureReferenceBean)new StructureReferenceBeanImpl(dataStructure.getAgencyId(), dataStructure.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.DSD, new String[0]));
        dataFlow.setId(String.valueOf(this.targetId) + "_dataFlow");
        dataFlow.setVersion(this.targetVersion);
        dataFlow.addName("en", String.valueOf(this.targetId) + " Data Flow");
        return dataFlow;
    }

    private Table getAssociatedCodelist(TemplateColumn<?> column) {
        this.log.debug("Looking for table associated to column " + column.getId());
        Table response = null;
        ReferenceObject reference = column.getReference();
        if (reference instanceof DimensionReference) {
            this.log.debug("Found a table reference for Dimension column");
            DimensionReference dimensionReference = (DimensionReference)reference;
            this.log.debug("Loading referenced table...");
            Table relatedTable = this.cubeManager.getTable(dimensionReference.getTableId());
            if (relatedTable.getTableType().getCode().equals("CODELIST")) {
                this.log.debug("Table found " + relatedTable.getName());
                response = relatedTable;
            } else {
                this.log.debug("Referenced table is not a codelist");
            }
        }
        return response;
    }
}

