/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.agencies;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.gcube.data.analysis.tabulardata.operation.sdmx.agencies.AgencyLoader;
import org.gcube.data.analysis.tabulardata.operation.sdmx.agencies.exceptions.AgencyException;
import org.gcube.data.analysis.tabulardata.operation.sdmx.agencies.managers.AgencyManager;
import org.gcube.data.analysis.tabulardata.operation.sdmx.configuration.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgencyProvider {
    private AgencyLoader agencyLoader;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static AgencyProvider instance;
    public static final String TABMAN_AGENCY = "tabman";
    public static final String USER_AGENCY = "user";
    private LinkedList<AgencyManager> agencyManagerList;
    private final String AGENCY_MANAGER_MAP = "agency.manager.map";

    private AgencyProvider() {
        String[] agencyManagerMapString;
        this.agencyLoader = new AgencyLoader();
        this.agencyManagerList = new LinkedList();
        for (String agencyManagerTag : agencyManagerMapString = ConfigurationManager.getInstance().getValue("agency.manager.map").split(",")) {
            agencyManagerTag = agencyManagerTag.trim();
            String agencyManagerTagQN = "agency.manager.map." + agencyManagerTag;
            this.logger.debug("Agency manager tag " + agencyManagerTag);
            String agencyManagerClassName = ConfigurationManager.getInstance().getValue(agencyManagerTagQN);
            this.logger.debug("Agency manager class " + agencyManagerClassName);
            try {
                this.logger.debug("Generating new class by reflection");
                Class<?> agencyManagerClass = Class.forName(agencyManagerClassName);
                AgencyManager agencyManager = (AgencyManager)agencyManagerClass.newInstance();
                agencyManager.setId(agencyManagerTag);
                this.logger.debug("Class and object generated");
                this.agencyManagerList.add(agencyManager);
            }
            catch (Exception e) {
                this.logger.error("Unable to generate agency manager " + agencyManagerTag, (Throwable)e);
            }
        }
    }

    public static AgencyProvider getInstance() {
        if (instance == null) {
            instance = new AgencyProvider();
        }
        return instance;
    }

    public String getAgency(String tabmanAgency, String userAgency, String[] registryParameters) throws AgencyException {
        this.logger.debug("Selecting the correct agency...");
        this.logger.debug("Defining operations sequence");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TABMAN_AGENCY, tabmanAgency);
        parameters.put(USER_AGENCY, userAgency);
        parameters.put("registryURL", registryParameters[0]);
        parameters.put("registryUserName", registryParameters[1]);
        parameters.put("registryPassword", registryParameters[2]);
        this.logger.debug("Executing operations");
        String response = null;
        Iterator agencyTagIterator = this.agencyManagerList.iterator();
        int priority = 1;
        while (agencyTagIterator.hasNext() && response == null) {
            AgencyManager agencyManager = (AgencyManager)agencyTagIterator.next();
            this.logger.debug("Loading agency manager of priproty " + priority++ + " id " + agencyManager.getId());
            response = agencyManager.execute(parameters, this.agencyLoader);
        }
        if (response == null) {
            this.logger.error("No suitable agency found");
            throw new AgencyException("No suitable agency found");
        }
        return response;
    }
}

