/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.sdmx.DataInformationProvider;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.codelist.SDMXCodelistGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.conceptscheme.SDMXConceptSchemeGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.SDMXDataOperationExecutor;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.SDMXDataBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.SDMXDataResultBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.resource.SDMXDataStructureDefinitionResourceBuilder;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.RepresentationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataflowMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.PrimaryMeasureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.RepresentationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.AttributeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DataStructureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.PrimaryMeasureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.DataflowMutableBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXDataOperationManager
extends ResourceCreatorWorker {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Table table;
    private OperationInvocation invocation;
    private CubeManager cubeManager;
    private final String ATTRIBUTE_ASSIGNMENT_STATUS_MANDATORY = "Mandatory";
    private static String errorMessage = "Unable to complete export procedure";
    private DatabaseConnectionProvider connectionProvider;
    private SDMXConceptSchemeGenerator conceptSchemeGenerator;
    private List<SDMXDataOperationExecutor> executors;
    private SDMXDataStructureDefinitionResourceBuilder resourceBuilder;

    SDMXDataOperationManager(Table table, DatabaseConnectionProvider connectionProvider, OperationInvocation invocation, CubeManager cubeManager, List<SDMXDataOperationExecutor> executors, SDMXDataStructureDefinitionResourceBuilder resourceBuilder) {
        super(invocation);
        this.table = table;
        this.invocation = invocation;
        this.connectionProvider = connectionProvider;
        this.cubeManager = cubeManager;
        this.executors = executors;
        this.resourceBuilder = resourceBuilder;
    }

    protected ResourcesResult execute() throws WorkerException {
        this.log.debug("Init parameters and functionalities");
        Parameters parameters = this.getParameters(this.invocation);
        this.conceptSchemeGenerator = new SDMXConceptSchemeGenerator(this.table, parameters.targetId, parameters.targetAgency, parameters.targetVersion);
        List<LocalizedText> tableNamesMetadata = this.loadMetadata();
        SDMXDataBean dataBean = this.generateSDMXDataBean(this.table, parameters.targetAgency, parameters.targetVersion, parameters.targetId, tableNamesMetadata);
        this.log.debug("Parameters and functionalities initialized");
        try {
            this.updateProgress(0.1f, "Creating beans");
            ConceptSchemeMutableBean conceptScheme = this.conceptSchemeGenerator.createConceptSchemeBean();
            dataBean.setConcepts(conceptScheme);
            DataflowMutableBean dataFlow = this.createDataFlowBean(dataBean.getDsd(), tableNamesMetadata, parameters);
            dataBean.setDataFlow(dataFlow);
            this.updateProgress(0.2f, "Populating data structure");
            this.populateDataStructure(dataBean, parameters);
            SDMXDataResultBean currentResult = new SDMXDataResultBean();
            Iterator<SDMXDataOperationExecutor> executorsIterator = this.executors.iterator();
            LinkedList<String> warnings = new LinkedList<String>();
            this.updateProgress(0.4f, "Executing requested operations");
            float currentStep = 0.4f;
            float step = this.getUpdateProgress(currentStep, this.executors.size());
            while (executorsIterator.hasNext() && currentResult.getResult() == SDMXDataResultBean.RESULT.OK) {
                SDMXDataOperationExecutor executor = executorsIterator.next();
                this.updateProgress(currentStep += step, "Executing " + executor.getOperationName());
                currentResult = executor.executeOperation(dataBean, this.invocation);
                if (currentResult.getResult() != SDMXDataResultBean.RESULT.WARNING) continue;
                warnings.add(currentResult.getMessage());
            }
            if (currentResult.getResult() == SDMXDataResultBean.RESULT.ERROR && currentResult.getException() != null) {
                this.log.error("Unable to complete the operation", currentResult.getException());
                throw new WorkerException(currentResult.getMessage(), currentResult.getException());
            }
            if (currentResult.getResult() == SDMXDataResultBean.RESULT.ERROR) {
                this.log.error("Unable to complete the operation");
                throw new WorkerException(currentResult.getMessage());
            }
            if (warnings.size() > 0) {
                for (String warning : warnings) {
                    this.log.warn(warning);
                }
            }
            this.updateProgress(0.9f, "Finalizing");
            return this.resourceBuilder.buildResourceResult(this.invocation, dataBean);
        }
        catch (RuntimeException e) {
            this.log.error(errorMessage, (Throwable)e);
            throw new WorkerException(errorMessage, (Throwable)e);
        }
    }

    private float getUpdateProgress(float startingPoint, int size) {
        float remainingSteps = 0.8f - startingPoint;
        return remainingSteps / (float)size;
    }

    private SDMXDataBean generateSDMXDataBean(Table table, String targetAgency, String targetVersion, String targetId, List<LocalizedText> tableNamesMetadata) {
        SDMXDataBean dataBean = new SDMXDataBean(table);
        DataStructureMutableBeanImpl dataStructureDefinition = new DataStructureMutableBeanImpl();
        dataStructureDefinition.setAgencyId(targetAgency);
        dataStructureDefinition.setVersion(targetVersion);
        String dsdId = targetId + "_DSD";
        dataStructureDefinition.setId(dsdId);
        try {
            ArrayList names = Lists.newArrayList();
            for (LocalizedText text : ((NamesMetadata)table.getMetadata(NamesMetadata.class)).getTexts()) {
                String locale = text.getLocale();
                String value = text.getValue();
                this.log.debug("Locale = " + locale);
                this.log.debug("Value " + value);
                names.add(new TextTypeWrapperMutableBeanImpl(locale, value));
            }
            dataStructureDefinition.setNames((List)names);
            this.log.debug("Names set");
        }
        catch (NoSuchMetadataException e) {
            this.log.warn("Names Metadata not found in the table");
            dataStructureDefinition.setNames(this.getNamesMetadata(tableNamesMetadata, targetId + " Data Structure Definition", "en"));
        }
        dataBean.setDsd((DataStructureMutableBean)dataStructureDefinition);
        dataBean.setID(targetId + "_" + targetVersion);
        return dataBean;
    }

    private Parameters getParameters(OperationInvocation invocation) {
        Parameters parameters = new Parameters();
        parameters.targetAgency = (String)invocation.getParameterInstances().get("agency");
        parameters.targetId = (String)invocation.getParameterInstances().get("id");
        parameters.targetVersion = (String)invocation.getParameterInstances().get("version");
        String observationValue = (String)invocation.getParameterInstances().get("obsValueColumn");
        parameters.primaryMeasure = this.table.getColumnById(new ColumnLocalId(observationValue));
        return parameters;
    }

    private void registerTimeDimensionColumn(Column column, ConceptMutableBean concept, SDMXDataBean dataStructure) {
        this.log.debug("Adding time dimension to excel table");
        dataStructure.setTimeDimension(column, concept);
        this.log.debug("Time dimension added");
    }

    private void registerDimensionColumn(Column column, ConceptMutableBean concept, CodelistBean immutableCodelist, SDMXDataBean dataStructure) {
        this.log.debug("Adding generic dimension to excel table");
        dataStructure.addDimensionColumn(column, concept, immutableCodelist);
        this.log.debug("Generic dimension added");
    }

    private void populateDataStructure(SDMXDataBean dataStructure, Parameters parameters) throws WorkerException {
        ArrayList<Column> columnsList = new ArrayList<Column>();
        columnsList.add(parameters.primaryMeasure);
        this.log.debug("Pupulating data structure");
        ArrayList<Column> measureColumns = new ArrayList<Column>();
        this.getMeasures(measureColumns, parameters);
        columnsList.addAll(measureColumns);
        this.log.debug("Measure columns loaded");
        this.addPrimaryMeasure(dataStructure, parameters);
        this.log.debug("Primary measure added");
        this.addMeasureDimensions(dataStructure, measureColumns, parameters);
        this.log.debug("Measure dimensions added");
        this.log.debug("Adding generic dimension bean");
        List dimensionColumns = this.table.getColumnsByType(new Class[]{DimensionColumnType.class});
        this.addGenericDimensions(dataStructure, dimensionColumns, parameters);
        columnsList.addAll(dimensionColumns);
        this.log.debug("Dimension columns added");
        Column timeDimensionColumn = (Column)this.table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}).get(0);
        this.addTimeDimension(dataStructure, timeDimensionColumn, parameters);
        columnsList.add(timeDimensionColumn);
        List attributeColumns = this.table.getColumnsByType(new Class[]{AttributeColumnType.class});
        this.addObservationAttributes(dataStructure, attributeColumns, parameters);
        columnsList.addAll(attributeColumns);
        this.registerData(dataStructure, this.table, columnsList, this.connectionProvider);
    }

    private void addTimeDimension(SDMXDataBean dataStructure, Column timeDimensionColumn, Parameters parameters) {
        this.log.debug("Adding time dimension");
        ConceptSchemeMutableBean concepts = dataStructure.getConcepts();
        DimensionMutableBeanImpl timeDimensionBean = new DimensionMutableBeanImpl();
        timeDimensionBean.setId("TIME_PERIOD");
        ConceptMutableBean timeDimensionConcept = this.conceptSchemeGenerator.createConceptBean(timeDimensionColumn);
        concepts.addItem((ItemMutableBean)timeDimensionConcept);
        timeDimensionBean.setConceptRef(this.getConceptReference(concepts, timeDimensionConcept, parameters.targetVersion));
        timeDimensionBean.setTimeDimension(true);
        dataStructure.getDsd().addDimension((DimensionMutableBean)timeDimensionBean);
        this.registerTimeDimensionColumn(timeDimensionColumn, timeDimensionConcept, dataStructure);
    }

    private void addGenericDimensions(SDMXDataBean dataStructure, List<Column> dimensionColumns, Parameters parameters) {
        ConceptSchemeMutableBean concepts = dataStructure.getConcepts();
        for (Column column : dimensionColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            CodelistBean immutableCodelist = this.createCodeListRepresentation(column, parameters);
            if (immutableCodelist != null) {
                columnConcept.setCoreRepresentation(this.getCoreRepresentation(immutableCodelist));
            }
            StructureReferenceBean conceptsReference = this.getConceptReference(concepts, columnConcept, parameters.targetVersion);
            DimensionMutableBeanImpl dimension = new DimensionMutableBeanImpl();
            dimension.setId(DataInformationProvider.getInstance().getColumnConverter().local2Registry(column.getLocalId().getValue()));
            dimension.setConceptRef(conceptsReference);
            dataStructure.getDsd().addDimension((DimensionMutableBean)dimension);
            this.registerDimensionColumn(column, columnConcept, immutableCodelist, dataStructure);
        }
    }

    private void addObservationAttributes(SDMXDataBean dataStructure, List<Column> attributeColumns, Parameters parameters) {
        this.log.debug("Adding attribute list bean");
        ConceptSchemeMutableBean concepts = dataStructure.getConcepts();
        for (Column column : attributeColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            CodelistBean immutableCodelist = this.createCodeListRepresentation(column, parameters);
            if (immutableCodelist != null) {
                columnConcept.setCoreRepresentation(this.getCoreRepresentation(immutableCodelist));
            }
            StructureReferenceBean conceptsReference = this.getConceptReference(concepts, columnConcept, parameters.targetVersion);
            AttributeMutableBeanImpl attributeBean = new AttributeMutableBeanImpl();
            attributeBean.setId(DataInformationProvider.getInstance().getColumnConverter().local2Registry(column.getLocalId().getValue()));
            attributeBean.setAttachmentLevel(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION);
            attributeBean.setAssignmentStatus("Mandatory");
            attributeBean.setConceptRef(conceptsReference);
            dataStructure.getDsd().addAttribute((AttributeMutableBean)attributeBean);
            this.registerAttributeColumn(column, columnConcept, immutableCodelist, dataStructure);
        }
    }

    private void registerAttributeColumn(Column column, ConceptMutableBean concept, CodelistBean immutableCodelist, SDMXDataBean dataStructure) {
        this.log.debug("Adding attribute to excel table");
        dataStructure.addAttributeColumn(column, concept, immutableCodelist);
        this.log.debug("Attribute dimension added");
    }

    private void registerPrimaryMeasure(Column column, ConceptMutableBean concept, SDMXDataBean dataStructure) {
        this.log.debug("Adding primary measure to excel table");
        dataStructure.setPrimaryMeasure(column, concept);
        this.log.debug("Primary measure added");
    }

    private RepresentationMutableBean getCoreRepresentation(CodelistBean immutableCodelist) {
        RepresentationMutableBeanImpl coreRepresentation = new RepresentationMutableBeanImpl();
        coreRepresentation.setRepresentation((StructureReferenceBean)new StructureReferenceBeanImpl((IdentifiableBean)immutableCodelist));
        this.log.debug("Found a code list representation");
        return coreRepresentation;
    }

    private void getMeasures(List<Column> measures, Parameters parameters) {
        this.log.debug("Loading measures");
        measures.addAll(this.table.getColumnsByType(new Class[]{MeasureColumnType.class}));
        measures.remove(parameters.primaryMeasure);
    }

    private void addPrimaryMeasure(SDMXDataBean dataStructure, Parameters parameters) {
        ConceptMutableBean primaryMeasureConcept = this.conceptSchemeGenerator.createConceptBean(parameters.primaryMeasure);
        dataStructure.getConcepts().addItem((ItemMutableBean)primaryMeasureConcept);
        StructureReferenceBeanImpl conceptReferenceBean = new StructureReferenceBeanImpl(primaryMeasureConcept.getParentAgency(), dataStructure.getConcepts().getId(), parameters.targetVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{primaryMeasureConcept.getId()});
        PrimaryMeasureMutableBeanImpl primaryMeasureBean = new PrimaryMeasureMutableBeanImpl();
        primaryMeasureBean.setConceptRef((StructureReferenceBean)conceptReferenceBean);
        primaryMeasureBean.setId("OBS_VALUE");
        dataStructure.getDsd().setPrimaryMeasure((PrimaryMeasureMutableBean)primaryMeasureBean);
        this.registerPrimaryMeasure(parameters.primaryMeasure, primaryMeasureConcept, dataStructure);
        this.log.debug("Primary measure added");
    }

    private void addMeasureDimensions(SDMXDataBean dataStructure, List<Column> measures, Parameters parameters) {
        this.log.debug("Adding measure dimension list bean");
        ConceptSchemeMutableBean concepts = dataStructure.getConcepts();
        for (Column column : measures) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            DimensionMutableBeanImpl dimensionBean = new DimensionMutableBeanImpl();
            dimensionBean.setId(column.getLocalId().getValue());
            dimensionBean.setMeasureDimension(true);
            dimensionBean.setConceptRef(this.getConceptReference(concepts, columnConcept, parameters.targetVersion));
            dataStructure.getDsd().addDimension((DimensionMutableBean)dimensionBean);
            this.registerMeasureColumn(column, columnConcept, dataStructure);
        }
    }

    private void registerMeasureColumn(Column column, ConceptMutableBean concept, SDMXDataBean dataStructure) {
        this.log.debug("Adding measure to excel table");
        dataStructure.addMeasureColumn(column, concept);
        this.log.debug("Measure added");
    }

    private StructureReferenceBean getConceptReference(ConceptSchemeMutableBean conceptScheme, ConceptMutableBean concept, String conceptVersion) {
        this.log.debug("Creating reference for concept " + concept.getId());
        return new StructureReferenceBeanImpl(concept.getParentAgency(), conceptScheme.getId(), conceptVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{concept.getId()});
    }

    private CodelistBean createCodeListRepresentation(Column column, Parameters parameters) {
        this.log.debug("Creating codelist bean");
        CodelistBean response = null;
        Table codelist = this.getAssociatedCodelist(column);
        if (codelist != null) {
            this.log.debug("Table found " + codelist.getName());
            SDMXCodelistGenerator codeListGenerator = new SDMXCodelistGenerator(codelist, this.connectionProvider, parameters.targetAgency, codelist.getName() + "_CL", parameters.targetVersion);
            CodelistMutableBean codeListBean = codeListGenerator.createBaseCodelistBean();
            try {
                codeListGenerator.populateCodelistWithCodes(codeListBean);
                response = codeListBean.getImmutableInstance();
            }
            catch (Exception e) {
                this.log.warn("Codelist not loaded", (Throwable)e);
            }
        }
        return response;
    }

    private DataflowMutableBean createDataFlowBean(DataStructureMutableBean dataStructure, List<LocalizedText> tableNamesMetadata, Parameters parameters) {
        DataflowMutableBeanImpl dataFlow = new DataflowMutableBeanImpl();
        this.log.debug("Populating data flow bean");
        dataFlow.setAgencyId(parameters.targetAgency);
        dataFlow.setDataStructureRef((StructureReferenceBean)new StructureReferenceBeanImpl(dataStructure.getAgencyId(), dataStructure.getId(), parameters.targetVersion, SDMX_STRUCTURE_TYPE.DSD, new String[0]));
        dataFlow.setId(parameters.targetId + "_dataFlow");
        dataFlow.setVersion(parameters.targetVersion);
        dataFlow.setNames(this.getNamesMetadata(tableNamesMetadata, parameters.targetId + " Data Flow", "en"));
        return dataFlow;
    }

    private List<LocalizedText> loadMetadata() {
        List tableNamesMetadata = null;
        try {
            tableNamesMetadata = ((NamesMetadata)this.table.getMetadata(NamesMetadata.class)).getTexts();
        }
        catch (NoSuchMetadataException e) {
            tableNamesMetadata = Lists.newArrayList();
        }
        return tableNamesMetadata;
    }

    protected List<TextTypeWrapperMutableBean> getNamesMetadata(List<LocalizedText> metadataValues, String defaultValue, String defaultLocale) {
        ArrayList response = Lists.newArrayList();
        if (metadataValues.size() == 0 && defaultValue != null) {
            this.log.warn("Names Metadata: using default value " + defaultValue);
            response.add(new TextTypeWrapperMutableBeanImpl(defaultLocale, defaultValue));
        } else {
            for (LocalizedText text : metadataValues) {
                this.log.debug("Adding metadata value " + text.getValue() + " " + text.getLocale());
                response.add(new TextTypeWrapperMutableBeanImpl(text.getLocale(), text.getValue()));
            }
        }
        return response;
    }

    private Table getAssociatedCodelist(Column column) {
        this.log.debug("Looking for table associated to column " + column.getLocalId());
        ColumnRelationship cr = column.getRelationship();
        this.log.debug("Relationship " + cr);
        Table response = null;
        if (cr != null) {
            this.log.debug("Loading referenced table...");
            Table relatedTable = this.cubeManager.getTable(cr.getTargetTableId());
            if (relatedTable.getTableType().getCode().equals("CODELIST")) {
                this.log.debug("Table found " + relatedTable.getName());
                response = relatedTable;
            } else {
                this.log.debug("Referenced table is not a codelist");
            }
        } else {
            this.log.debug("No related table found");
        }
        return response;
    }

    private boolean dataAware() {
        boolean dataAware = false;
        Iterator<SDMXDataOperationExecutor> executorIterator = this.executors.iterator();
        while (!dataAware && executorIterator.hasNext()) {
            dataAware = executorIterator.next().isDataAware();
        }
        return dataAware;
    }

    private void registerData(SDMXDataBean dataStructure, Table table, List<Column> columns, DatabaseConnectionProvider connectionProvider) {
        if (this.dataAware()) {
            this.log.debug("Registering data for excel");
            try {
                Map<String, List<String>> data = this.getData(table, columns, connectionProvider);
                for (String columnName : data.keySet()) {
                    this.log.debug("Adding data for column " + columnName);
                    dataStructure.addData(columnName, data.get(columnName));
                    this.log.debug("Data added");
                }
            }
            catch (SQLException e) {
                this.log.error("Unable to register excel data", (Throwable)e);
            }
        } else {
            this.log.debug("No data requested");
        }
    }

    private Map<String, List<String>> getData(Table table, List<Column> columns, DatabaseConnectionProvider connectionProvider) throws SQLException {
        HashMap<String, LinkedList<String>> hashMap;
        this.log.debug("Downloading data");
        String query = this.buildSqlQuery(table, columns);
        this.log.debug("Query " + query);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            HashMap<String, LinkedList<String>> response = new HashMap<String, LinkedList<String>>();
            while (rs.next()) {
                for (Column column : columns) {
                    String columnName = column.getName();
                    this.log.debug("Adding data for column " + columnName);
                    LinkedList<String> dataList = (LinkedList<String>)response.get(columnName);
                    if (dataList == null) {
                        dataList = new LinkedList<String>();
                        response.put(columnName, dataList);
                    }
                    dataList.add(rs.getString(columnName));
                }
            }
            hashMap = response;
        }
        catch (SQLException e) {
            try {
                this.log.error("Unable to execute database query.", (Throwable)e);
                if (e.getNextException() != null) {
                    this.log.error("Inner Exception: ", (Throwable)e.getNextException());
                }
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return hashMap;
    }

    private String buildSqlQuery(Table table, List<Column> columns) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        for (Column column : columns) {
            sql.append(column.getName() + " , ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" FROM " + table.getName() + ";");
        return sql.toString();
    }

    private class Parameters {
        String targetAgency;
        String targetId;
        String targetVersion;
        Column primaryMeasure;

        private Parameters() {
        }
    }
}

