/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.configuration;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties genericConfiguration = new Properties();
    private static ConfigurationManager instance;

    private ConfigurationManager() {
        try {
            this.genericConfiguration.load(this.getClass().getResourceAsStream("/generic-settings.properties"));
        }
        catch (Exception e) {
            this.logger.error("Unable to load configuration file", (Throwable)e);
        }
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    public String getValue(String name) {
        return this.genericConfiguration.getProperty(name);
    }

    public String getValue(String name, String defaultValue) {
        return this.genericConfiguration.getProperty(name, defaultValue);
    }
}

