/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnection;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.csv.exporter.CSVExportFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.Constants;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;

public class ExportToStatisticalOperation
extends ResourceCreatorWorker {
    private CSVExportFactory csvExportFactory;
    private CubeManager cubeManager;
    private StatisticalManagerDataSpace statisticalDataSpace;
    private Table targetTable;
    private ImmutableURIResult exportedTable;
    private String dataSpaceTableId;
    private String user;

    public ExportToStatisticalOperation(OperationInvocation sourceInvocation, CSVExportFactory csvExportFactory, CubeManager cubeManager, StatisticalManagerDataSpace statisticalDataSpace) {
        super(sourceInvocation);
        this.csvExportFactory = csvExportFactory;
        this.cubeManager = cubeManager;
        this.statisticalDataSpace = statisticalDataSpace;
    }

    public ResourcesResult execute() throws WorkerException {
        this.loadParameters();
        this.updateProgress(0.1f, "Creating csv");
        this.exportCSV();
        this.updateProgress(0.5f, "Saving to user's SM dataspace");
        this.importIntoDataSpace();
        this.updateProgress(0.9f, "Finalizing");
        try {
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(String.valueOf(Constants.STATISTICAL_URI_PREFIX) + ":" + this.dataSpaceTableId), this.dataSpaceTableId), OperationHelper.retrieveTableLabel((Table)this.targetTable), "Statistical dataspace CSV version", ResourceType.CSV));
        }
        catch (URISyntaxException e) {
            throw new WorkerException("Statistical URI is invalid", (Throwable)e);
        }
    }

    private void loadParameters() {
        Map params = this.getSourceInvocation().getParameterInstances();
        this.user = (String)params.get(StatisticalOperationFactory.USER.getIdentifier());
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
    }

    private void exportCSV() throws WorkerException {
        block4: {
            HashMap<String, Object> exportParams = new HashMap<String, Object>();
            ArrayList<String> columns = new ArrayList<String>();
            for (Column col : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
                columns.add(col.getName());
            }
            exportParams.put("columns", columns);
            exportParams.put("encoding", Charset.defaultCharset().toString());
            exportParams.put("separator", ",");
            WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.csvExportFactory);
            try {
                WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, exportParams);
                if (status.equals((Object)WorkerStatus.SUCCEDED)) {
                    this.exportedTable = (ImmutableURIResult)((ResourcesResult)wrapper.getResult()).getResources().get(0);
                    break block4;
                }
                throw new WorkerException("Failed export to CSV, worker status was " + status);
            }
            catch (InvalidInvocationException e) {
                throw new WorkerException("Unable to export table as CSV", (Throwable)e);
            }
        }
    }

    private void importIntoDataSpace() throws WorkerException {
        String template = "GENERIC";
        TableTemplates tableTemplate = null;
        TableTemplates[] tableTemplatesArray = TableTemplates.values();
        int n = tableTemplatesArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableTemplates t = tableTemplatesArray[n2];
            if (template.contentEquals(t.toString())) {
                tableTemplate = t;
                break;
            }
            ++n2;
        }
        boolean hasHeader = true;
        String delimiter = ",";
        try {
            File f = this.getInputFile();
            this.dataSpaceTableId = this.statisticalDataSpace.createTableFromCSV(f, hasHeader, delimiter, "", "TDM - " + this.exportedTable.getDescription(), tableTemplate, "Exported from TDM", this.user);
        }
        catch (NoSuchMetadataException e) {
            throw new WorkerException("Unable to locate exported CSV file", (Throwable)e);
        }
        catch (Exception e) {
            throw new WorkerException("Unable to locate exported CSV file", (Throwable)e);
        }
    }

    private File getInputFile() throws Exception {
        InputStream inputStream = new URL(null, this.exportedTable.getResource().getStringValue(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                return new SMPURLConnection(url);
            }
        }).openStream();
        File tempFile = File.createTempFile("import", ".csv");
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes)) != -1) {
            ((OutputStream)outputStream).write(bytes, 0, read);
        }
        ((OutputStream)outputStream).close();
        inputStream.close();
        return tempFile;
    }
}

