/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical.specific;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.SimpleStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TDTypeValueParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.specific.EnhanceLatLong;
import org.gcube.data.analysis.tabulardata.statistical.specific.LatLongFeature;

@Singleton
public class EnhanceLatLonFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(10101L);
    private static final List<TableType> allTableTypes = new ArrayList<TableType>();
    private static final List<ColumnType> numericTypes = new ArrayList<ColumnType>();
    private static final List<DataType> numericDataTypes = new ArrayList<DataType>();
    private static final List<String> features = new ArrayList<String>();
    public static final TargetColumnParameter LATITUDE_COLUMN_PARAM;
    public static final TargetColumnParameter LONGITUTE_COLUMN_PARAM;
    public static final TargetColumnParameter QUADRANT_COLUMN_PARAMETER;
    public static final TDTypeValueParameter RESOLUTION_PARAM;
    public static final MultivaluedStringParameter TO_ADD_FEATURE_PARAM;
    public static final SimpleStringParameter USER;
    private static List<Parameter> params;
    private CubeManager cm;
    private StatisticalOperationFactory statFactory;
    private AddColumnFactory addColFactory;

    static {
        allTableTypes.add((TableType)new CodelistTableType());
        allTableTypes.add((TableType)new DatasetTableType());
        allTableTypes.add((TableType)new DatasetViewTableType());
        allTableTypes.add((TableType)new GenericTableType());
        allTableTypes.add((TableType)new HierarchicalCodelistTableType());
        allTableTypes.add((TableType)new TimeCodelistTableType());
        numericTypes.add((ColumnType)new AttributeColumnType());
        numericTypes.add((ColumnType)new MeasureColumnType());
        numericTypes.add((ColumnType)new AnnotationColumnType());
        numericDataTypes.add((DataType)new IntegerType());
        numericDataTypes.add((DataType)new NumericType());
        LatLongFeature[] latLongFeatureArray = LatLongFeature.values();
        int n = latLongFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            LatLongFeature feat = latLongFeatureArray[n2];
            features.add(feat.name());
            ++n2;
        }
        LATITUDE_COLUMN_PARAM = new TargetColumnParameter("latitude", "Latitude Column", "The column containing latitude information", Cardinality.ONE, allTableTypes, numericTypes, numericDataTypes);
        LONGITUTE_COLUMN_PARAM = new TargetColumnParameter("longitude", "Longitude Column", "The column containing longitude information", Cardinality.ONE, allTableTypes, numericTypes, numericDataTypes);
        QUADRANT_COLUMN_PARAMETER = new TargetColumnParameter("quadrant", "Quadrant Column", "The column containing quadrant information", Cardinality.OPTIONAL, allTableTypes, numericTypes, numericDataTypes);
        RESOLUTION_PARAM = new TDTypeValueParameter("resolution", "CSquare Code Resolution", "Resolution of the resulting csquarecodes", Cardinality.OPTIONAL, Collections.singletonList(new NumericType()));
        TO_ADD_FEATURE_PARAM = new MultivaluedStringParameter("feature", "To Add Feature", "Feature to be added to the table", Cardinality.ONE, features);
        USER = StatisticalOperationFactory.USER;
        params = Arrays.asList(LATITUDE_COLUMN_PARAM, LONGITUTE_COLUMN_PARAM, QUADRANT_COLUMN_PARAMETER, RESOLUTION_PARAM, TO_ADD_FEATURE_PARAM, USER);
    }

    @Inject
    public EnhanceLatLonFactory(CubeManager cm, StatisticalOperationFactory statFactory, AddColumnFactory addColFactory) {
        this.cm = cm;
        this.statFactory = statFactory;
        this.addColFactory = addColFactory;
    }

    public DataWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cm);
        this.performSpecificChecks(arg0);
        return new EnhanceLatLong(arg0, this.statFactory, this.addColFactory, this.cm);
    }

    private void performSpecificChecks(OperationInvocation invocation) throws InvalidInvocationException {
        TableId tableId = invocation.getTargetTableId();
        if (!((ColumnReference)OperationHelper.getParameter((LeafParameter)LATITUDE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId().equals((Object)tableId)) {
            throw new InvalidInvocationException(invocation, "Latitude column not present in this table, tableID is : " + ((ColumnReference)OperationHelper.getParameter((LeafParameter)LATITUDE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId());
        }
        if (!((ColumnReference)OperationHelper.getParameter((LeafParameter)LONGITUTE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId().equals((Object)tableId)) {
            throw new InvalidInvocationException(invocation, "Longitude column not present in this table, tableID is : " + ((ColumnReference)OperationHelper.getParameter((LeafParameter)LATITUDE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId());
        }
        try {
            if (!((ColumnReference)OperationHelper.getParameter((LeafParameter)QUADRANT_COLUMN_PARAMETER, (OperationInvocation)invocation)).getTableId().equals((Object)tableId)) {
                throw new InvalidInvocationException(invocation, "Quadrant column not present in this table, tableID is : " + ((ColumnReference)OperationHelper.getParameter((LeafParameter)LATITUDE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getOperationDescription() {
        return "Adds a geospatial feature based on latitude and longitude columns, relying on Statistical Manager's facilities.";
    }

    protected String getOperationName() {
        return "EnhanceLatLong";
    }

    protected List<Parameter> getParameters() {
        return params;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

