package org.gcube.data.analysis.tabulardata.statistical;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;

import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMListGroupedAlgorithms;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.statistical.specific.LatLongFeature;

public class Common {

	
	public static boolean isValidColumnName(Column col) throws ParseException, IOException, ProcessingException{
		String currentLabel=OperationHelper.retrieveColumnLabel(col);
		return isValidString(currentLabel);
	}
	
	public static boolean isValidString(String str) throws ParseException, IOException, ProcessingException{
		return str.matches("^[a-z_][a-z_0-9]*")&&!ReservedWordsDictionary.getDictionary().isReservedKeyWord(str);
	}
	public static String fixColumnName(String columnName) throws ParseException, IOException, ProcessingException{
		String toReturn=columnName.replaceAll("\\W", "_").toLowerCase();
		if(isValidString(toReturn)) return toReturn;
		else return "_"+toReturn;
	}
	
	public static String fixColumnName(String columnName,String... additionalReservedWords) throws ParseException, IOException, ProcessingException{
		String toCheck=fixColumnName(columnName);
		for(String additional:additionalReservedWords)
			if(toCheck.equalsIgnoreCase(additional)) toCheck="_"+toCheck;
		return toCheck;
	}
	
	public static String fixColumnName(Column col) throws ParseException, IOException, ProcessingException{
		return fixColumnName(OperationHelper.retrieveColumnLabel(col));
	}
	
	
	public static Map<ColumnLocalId,String> curateLabels(Table table,String... additionalReservedWords) throws ParseException, IOException, ProcessingException{
		HashMap<ColumnLocalId,String> toReturn=new HashMap<ColumnLocalId,String>();
		HashMap<String,Integer> clashCounter=new HashMap<String,Integer>();
		for(Column col:table.getColumnsExceptTypes(IdColumnType.class,ValidationColumnType.class)){
			String originalLabel=OperationHelper.retrieveColumnLabel(col);
			String fixed=fixColumnName(originalLabel,additionalReservedWords);
			if(clashCounter.containsKey(fixed)){
				clashCounter.put(fixed, clashCounter.get(fixed)+1);
				fixed=fixed+"_"+clashCounter.get(fixed);
			}else clashCounter.put(fixed, 1);
			toReturn.put(col.getLocalId(), fixed);
		}
		return toReturn;
	}
	
	
	public static StatisticalManagerDataSpace getSMDataSpace(){
		return StatisticalManagerDSL.dataSpace().build();
	}
	
	public static StatisticalManagerFactory getSMFactory(){
		return StatisticalManagerDSL.createStateful().build();
	}
	
	public static boolean isSMAlgorithmAvailable(String algorithmId){
		StatisticalManagerFactory factory=getSMFactory();
		SMListGroupedAlgorithms groups = factory.getAlgorithms();
		for (SMGroupedAlgorithms group : groups.thelist()) {
		 for (SMAlgorithm algorithm : group.thelist()) {
			 if(algorithm.name().equals(algorithmId)) return true;
		 }
		}
		return false;
	}
	
}
