/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.apache.commons.io.IOUtils;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitor;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitorListener;
import org.gcube.data.analysis.dataminermanagercl.shared.data.OutputData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.Resource;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ParameterType;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GcubeServiceReferenceMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.Utils;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticalOperation
extends ResourceCreatorWorker {
    public static final Logger log = LoggerFactory.getLogger(StatisticalOperation.class);
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private SClient dmClient;
    private ExportToStatisticalOperationFactory exportFactory;
    private ImportFromStatisticalOperationFactory importFactory;
    private CubeManager cubeManager;
    private Operator operator;
    private Table targetTable;
    private GcubeServiceReferenceMetadata dataSpaceTable;
    private boolean clearDataspace = false;
    private boolean removeExported = false;
    private Map<String, String> toSerializeValues = new HashMap<String, String>();
    private List<ResourceDescriptorResult> results = new ArrayList<ResourceDescriptorResult>();
    ComputationId computationId = null;
    private Semaphore sem = new Semaphore(0);
    private OperationStatus status;
    private String errorMsg = "";

    public StatisticalOperation(OperationInvocation sourceInvocation, SClient dmClient, ExportToStatisticalOperationFactory exportFactory, ImportFromStatisticalOperationFactory importFactory, CubeManager cubeManager) {
        super(sourceInvocation);
        this.dmClient = dmClient;
        this.exportFactory = exportFactory;
        this.importFactory = importFactory;
        this.cubeManager = cubeManager;
    }

    protected ResourcesResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.getParameters();
            this.updateProgress(0.05f, "Checking if already exported to dataspace..");
            this.dataSpaceTable = this.getSMTable();
            this.checkAborted();
            this.updateProgress(0.2f, "Submitting computation");
            this.submitComputation();
            this.checkAborted();
            this.updateProgress(0.4f, "Waiting computation");
            this.waitForComputation();
            this.checkAborted();
            this.updateProgress(0.6f, "Importing results");
            this.generateTableFromResult();
            if (this.removeExported) {
                this.updateProgress(0.8f, "Cleaning up");
                this.deleteExternalReference(this.dataSpaceTable);
            }
            this.updateProgress(0.9f, "Finalizing");
            if (this.results.size() == 0) {
                throw new WorkerException("No resources were successfully imported from SM");
            }
            return new ResourcesResult(this.results);
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (OperationAbortedException e) {
            log.debug("Aborting operation");
            if (this.computationId != null) {
                try {
                    this.dmClient.cancelComputation(this.computationId);
                }
                catch (Exception e1) {
                    log.warn("Unexpected error while cancelling DM operation", (Throwable)e1);
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new WorkerException("Unexpected internal error. Please contact support", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serializeResultMap() {
        if (this.toSerializeValues.isEmpty()) return;
        PrintWriter writer = null;
        try {
            File serialized = File.createTempFile("result", ".txt");
            writer = new PrintWriter(serialized);
            for (Map.Entry<String, String> entry : this.toSerializeValues.entrySet()) {
                writer.println(entry.getKey() + " : " + entry.getValue());
            }
            IOUtils.closeQuietly((Writer)writer);
            IClient client = Utils.getStorageClient();
            String remotePath = "/SM_Integration/" + serialized.getName();
            client.put(true).LFile(serialized.getAbsolutePath()).RFile(remotePath);
            String id = client.put(true).LFile(serialized.getAbsolutePath()).RFile(remotePath);
            this.results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(id), "text/plain"), this.operator.getName() + " General results", "Text file containig etherogeneus results", ResourceType.GENERIC_FILE));
            if (writer == null) return;
        }
        catch (Exception e) {
            try {
                log.warn("Unable to write results to file ", (Throwable)e);
                if (writer == null) return;
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            return;
        }
        IOUtils.closeQuietly((Writer)writer);
        return;
    }

    public void getParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.operator = Common.getOperator(this.getSourceInvocation());
        try {
            this.clearDataspace = (Boolean)OperationHelper.getParameter((LeafParameter)StatisticalOperationFactory.CLEAR_DATASPACE, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.removeExported = (Boolean)OperationHelper.getParameter((LeafParameter)StatisticalOperationFactory.REMOVE_EXPORTED, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void submitComputation() throws ParseException, IOException, ProcessingException, Exception {
        Table toUseTable = this.targetTable;
        if (toUseTable.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)toUseTable.getMetadata(DatasetViewTableMetadata.class);
            toUseTable = this.cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
            log.debug("DataSetViewMetadata found with ID {} ", (Object)toUseTable.getId());
        }
        Map<ColumnLocalId, String> curatedColumnLabels = Common.curateLabels(toUseTable, new String[0]);
        String exportedId = null;
        try {
            new URL(this.dataSpaceTable.getExternalId());
            exportedId = this.dataSpaceTable.getExternalId();
        }
        catch (MalformedURLException e) {
            log.debug("Exported ID is not url, getting it from storage.. ");
            exportedId = Common.getURLFromStorageId(this.dataSpaceTable.getExternalId()).toString();
        }
        String toSubstituteTableId = toUseTable.getId().getValue() + "";
        log.debug("Going to adjust operator parameters. Operator {}", (Object)this.operator);
        log.debug("Reference table id {} ", (Object)toSubstituteTableId);
        log.debug("Curated labels : {} ", curatedColumnLabels.entrySet());
        for (Parameter param : this.operator.getOperatorParameters()) {
            String paramValue = param.getValue();
            ParameterType type = param.getTypology();
            if (type.equals((Object)ParameterType.FILE) || type.equals((Object)ParameterType.TABULAR) || type.equals((Object)ParameterType.TABULAR_LIST)) {
                param.setValue(paramValue.replaceAll(toSubstituteTableId, exportedId));
                continue;
            }
            if (!type.equals((Object)ParameterType.COLUMN) && !type.equals((Object)ParameterType.COLUMN_LIST)) continue;
            for (Map.Entry<ColumnLocalId, String> curatedEntry : curatedColumnLabels.entrySet()) {
                paramValue = paramValue.replaceAll(curatedEntry.getKey().getValue(), curatedEntry.getValue());
            }
            param.setValue(paramValue);
        }
        log.debug("Gonna submit operator {} ", (Object)this.operator);
        this.computationId = this.dmClient.startComputation(this.operator);
    }

    private void generateTableFromResult() throws WorkerException {
        try {
            OutputData output = this.dmClient.getOutputDataByComputationId(this.computationId);
            Resource theResource = output.getResource();
            String storageBasePath = this.operator.getName() + "/" + dateFormatter.format(new Date(System.currentTimeMillis()));
            Common.handleSMResource(storageBasePath, theResource, this.results, this.toSerializeValues, (WorkerWrapper<DataWorker, WorkerResult>)this.createWorkerWrapper((WorkerFactory)this.importFactory), this.clearDataspace);
            this.serializeResultMap();
        }
        catch (Exception e) {
            throw new WorkerException("Unable to retrieve result", (Throwable)e);
        }
    }

    private GcubeServiceReferenceMetadata getSMTable() throws WorkerException, OperationAbortedException {
        try {
            GcubeServiceReferenceMetadata meta = (GcubeServiceReferenceMetadata)this.targetTable.getMetadata(GcubeServiceReferenceMetadata.class);
            if (meta.getServiceClass().equals("WPS") && meta.getServiceName().equals("DataMiner")) {
                return meta;
            }
            throw new NoSuchMetadataException(GcubeServiceReferenceMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            this.updateProgress(0.1f, "Transferring to dataspace");
            return this.importIntoDataSpace();
        }
    }

    private GcubeServiceReferenceMetadata importIntoDataSpace() throws WorkerException, OperationAbortedException {
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.exportFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, this.getSourceInvocation().getParameterInstances());
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            return (GcubeServiceReferenceMetadata)this.cubeManager.getTable(this.targetTable.getId()).getMetadata(GcubeServiceReferenceMetadata.class);
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to export table to dataspace.", (Throwable)e);
        }
        catch (NoSuchMetadataException e) {
            throw new WorkerException("Unable to get dataspace table id for exported table", (Throwable)e);
        }
    }

    private void deleteExternalReference(GcubeServiceReferenceMetadata meta) {
        IClient client = Utils.getStorageClient();
        client.remove(meta.getExternalId());
        this.cubeManager.modifyTableMeta(this.targetTable.getId()).removeTableMetadata(GcubeServiceReferenceMetadata.class).create();
    }

    private void onComputationFinished(OperationStatus toSetStatus, String msg) {
        this.status = toSetStatus;
        this.errorMsg = msg;
        this.sem.release();
    }

    private void waitForComputation() throws WorkerException, OperationAbortedException {
        DMMonitorListener listener = new DMMonitorListener(){

            public void running(double percentage) {
                Float progress = new Float(percentage);
                StatisticalOperation.this.updateProgress(0.4f + progress.floatValue() / 100.0f * 0.2f, "Waiting for computation to complete");
                log.debug("Operation Running: " + percentage);
            }

            public void failed(String message, Exception exception) {
                log.error("Operation Failed");
                log.error(message, (Throwable)exception);
                StatisticalOperation.this.onComputationFinished(OperationStatus.FAILED, message);
            }

            public void complete(double percentage) {
                log.debug("Operation Completed");
                log.debug("Perc: " + percentage);
                StatisticalOperation.this.onComputationFinished(OperationStatus.COMPLETED, "");
            }

            public void cancelled() {
                log.debug("Operation Cancelled");
                StatisticalOperation.this.onComputationFinished(OperationStatus.ABORTED, "CANCELLED");
            }

            public void accepted() {
                log.debug("Operation Accepted");
            }
        };
        DMMonitor dmMonitor = new DMMonitor(this.computationId, this.dmClient);
        dmMonitor.add(listener);
        dmMonitor.start();
        try {
            this.sem.acquire();
        }
        catch (InterruptedException e) {
            log.debug("Woke up. Computation should be finished");
        }
        switch (this.status) {
            case ABORTED: {
                throw new OperationAbortedException();
            }
            case FAILED: {
                throw new WorkerException("Failed experiment. Cause " + this.errorMsg);
            }
            case WAITING: {
                throw new WorkerException("Incoherent status once finished monitoring. This should never happen. Please contact developer.");
            }
            case COMPLETED: {
                log.debug("Operation is complete");
            }
        }
    }

    private static enum OperationStatus {
        WAITING,
        COMPLETED,
        FAILED,
        ABORTED;

    }
}

