package org.gcube.data.analysis.tabulardata.operation.test.util;

import javax.inject.Inject;

import org.eclipse.persistence.jpa.jpql.Assert;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericHelper {
	
	private static final Logger log = LoggerFactory.getLogger(CodelistHelper.class);

	@Inject
	public CubeManager cm;

	@Inject
	private DatabaseConnectionProvider connectionProvider;

	@Inject
	private CopyHandler copyHandler;

	public Table createSpeciesGenericTable() {
		TableCreator tc = cm.createTable(new GenericTableType());
		Table table = null;

		// Create table structure
		try {
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			table = tc.create();
			log.debug("Created species generic table:\n" + table);
		} catch (Exception e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		}

		// Fill with data
		copyHandler.copy("cl_species.csv", table);
		return table;
	}
	
	public Table createNumbersGenericTable(){
		TableCreator tc = cm.createTable(new GenericTableType());
		Table table = null;

		// Create table structure
		try {
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			table = tc.create();
			log.debug("Created generic table with numbers:\n" + table);
		} catch (Exception e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		}

		// Fill with data
		copyHandler.copy("numbers.csv", table);
		return table;
	}
	
	public Table createComplexTable(){
		TableCreator tc = cm.createTable(new GenericTableType());
		Table table = null;

		// Create table structure
		try {
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create(new IntegerType()));
			tc.addColumn(AttributeColumnFactory.create(new NumericType()));
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create(new BooleanType()));
			tc.addColumn(AttributeColumnFactory.create());
			tc.addColumn(AttributeColumnFactory.create(new DateType()));
			table = tc.create();
			log.debug("Created table with complex types:\n" + table);
		} catch (Exception e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		}

		// Fill with data
		copyHandler.copy("complex.csv", table);
		return table;
	}
	
	public Table createDatasetWithSpecies(){
		TableCreator tc = cm.createTable(new GenericTableType());
		Table table = null;

		// Create table structure
		try {
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("First attribute"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Second attribute"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("English name"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Spanish name"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Species code"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("A measure"),new TextType()));
			table = tc.create();
			log.debug("Created generic dataset with species names and codes:\n" + table);
		} catch (Exception e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		}

		// Fill with data
		copyHandler.copy("speciesdataset.csv", table);
		return table;
	}
	
	public Table createTimePeriodTable(){
		TableCreator tc = cm.createTable(new GenericTableType());
		Table table = null;
		// Create table structure
		try {
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Valid day"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Invalid day"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Valid week"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Invalid week"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Valid month"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Invalid month"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Valid quarter"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Invalid quarter"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Valid year"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Invalid year"),new TextType()));
			tc.addColumn(AttributeColumnFactory.create(new ImmutableLocalizedText("Dates with null"),new TextType()));
			table = tc.create();
			log.debug("Created generic table with several time periods:\n" + table);
		} catch (Exception e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		}
		// Fill with data
		copyHandler.copy("timePeriod.csv", table);
		return table;
	}

}
