/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.test.util;

import javax.inject.Inject;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.ColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.test.util.CodelistHelper;
import org.gcube.data.analysis.tabulardata.operation.test.util.CopyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericHelper {
    private static final Logger log = LoggerFactory.getLogger(CodelistHelper.class);
    private ColumnFactory factory = BaseColumnFactory.getFactory((ColumnType)new AttributeColumnType());
    @Inject
    public CubeManager cm;
    @Inject
    private DatabaseConnectionProvider connectionProvider;
    @Inject
    private CopyHandler copyHandler;

    public Table createSpeciesGenericTable() {
        TableCreator tc = this.cm.createTable((TableType)new GenericTableType());
        Table table = null;
        try {
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            table = tc.create();
            log.debug("Created species generic table:\n" + table);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        this.copyHandler.copy("cl_species.csv", table);
        return table;
    }

    public Table createNumbersGenericTable() {
        TableCreator tc = this.cm.createTable((TableType)new GenericTableType());
        Table table = null;
        try {
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            table = tc.create();
            log.debug("Created generic table with numbers:\n" + table);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        this.copyHandler.copy("numbers.csv", table);
        return table;
    }

    public Table createComplexTable() {
        TableCreator tc = this.cm.createTable((TableType)new GenericTableType());
        Table table = null;
        try {
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.create((DataType)new IntegerType()));
            tc.addColumn(this.factory.create((DataType)new NumericType()));
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.create((DataType)new BooleanType()));
            tc.addColumn(this.factory.createDefault());
            tc.addColumn(this.factory.create((DataType)new DateType()));
            table = tc.create();
            log.debug("Created table with complex types:\n" + table);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        this.copyHandler.copy("complex.csv", table);
        return table;
    }

    public Table createDatasetWithSpecies() {
        TableCreator tc = this.cm.createTable((TableType)new GenericTableType());
        Table table = null;
        try {
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("First attribute"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Second attribute"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("English name"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Spanish name"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Species code"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("A measure"), (DataType)new TextType()));
            table = tc.create();
            log.debug("Created generic dataset with species names and codes:\n" + table);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        this.copyHandler.copy("speciesdataset.csv", table);
        return table;
    }

    public Table createTimePeriodTable() {
        TableCreator tc = this.cm.createTable((TableType)new GenericTableType());
        Table table = null;
        try {
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Valid day"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Invalid day"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Valid week"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Invalid week"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Valid month"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Invalid month"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Valid quarter"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Invalid quarter"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Valid year"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Invalid year"), (DataType)new TextType()));
            tc.addColumn(this.factory.create((LocalizedText)new ImmutableLocalizedText("Dates with null"), (DataType)new TextType()));
            table = tc.create();
            log.debug("Created generic table with several time periods:\n" + table);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        this.copyHandler.copy("timePeriod.csv", table);
        return table;
    }
}

