/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.view.charts;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.Resource;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.view.charts.TopRatingChartCreatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.remover.ResourceRemover;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class TopRatingChartCreatorWorker
extends ResourceCreatorWorker {
    CubeManager cubeManager;
    OperationInvocation sourceInvocation;
    DatabaseConnectionProvider connectionProvider;
    public static final String SERVICE_CLASS = "DataAnalysis";
    public static final String SERVICE_NAME = "TabularData";

    public TopRatingChartCreatorWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.sourceInvocation = sourceInvocation;
        this.connectionProvider = connectionProvider;
    }

    protected ResourcesResult execute() throws WorkerException {
        this.updateProgress(0.1f, "Retrieving parameters");
        Table table = this.cubeManager.getTable(this.sourceInvocation.getTargetTableId());
        int sampleSize = (Integer)OperationHelper.getParameter((LeafParameter)((LeafParameter)TopRatingChartCreatorFactory.SAMPLE_SIZE), (OperationInvocation)this.sourceInvocation);
        String opValue = (String)OperationHelper.getParameter((LeafParameter)((LeafParameter)TopRatingChartCreatorFactory.VALUE_OP), (OperationInvocation)this.sourceInvocation);
        Column dimColumn = table.getColumnById(this.sourceInvocation.getTargetColumnId());
        Column measureColumn = (Column)table.getColumnsByType(new Class[]{MeasureColumnType.class}).get(0);
        Column timeColumn = (Column)table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}).get(0);
        try {
            File image = this.createTopChart(measureColumn, timeColumn, dimColumn, table, sampleSize, opValue);
            this.updateProgress(0.8f, "Saving file on storage");
            InternalURI uri = this.getInternalUri(image);
            String columnLabel = ((NamesMetadata)dimColumn.getMetadata(NamesMetadata.class)).getTextWithLocale("en").getValue();
            image.delete();
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableURIResult(uri, "Top " + sampleSize + " chart", "Top " + sampleSize + " chart for column " + columnLabel, ResourceType.CHART));
        }
        catch (Exception e) {
            throw new WorkerException("error creating charts", (Throwable)e);
        }
    }

    private InternalURI getInternalUri(File exportFile) throws URISyntaxException {
        IClient client = new StorageClient(SERVICE_CLASS, SERVICE_NAME, "TDM", AccessType.SHARED, MemoryType.PERSISTENT).getClient();
        String remotePath = "/Charts/" + exportFile.getName();
        String id = client.put(true).LFile(exportFile.getAbsolutePath()).RFile(remotePath);
        return new InternalURI(new URI(client.getUrl().RFile(remotePath)), id);
    }

    private File createTopChart(Column measureColumn, Column timeColumn, Column dimColumn, Table targetTable, int sampleSize, String opValue) throws Exception {
        String title;
        Table externalRefTable = this.cubeManager.getTable(dimColumn.getRelationship().getTargetTableId());
        Column externalReferenceColumn = externalRefTable.getColumnById(dimColumn.getRelationship().getTargetColumnId());
        this.updateProgress(0.2f, "Getting top rated values");
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        String distinctValuesQuery = String.format("SELECT top.%1$s, %4$s.%2$s  FROM (SELECT %1$s, %6$s(%5$s) as s FROM %3$s GROUP BY %1$s) AS top, %4$s WHERE %4$s.id=top.%1$s ORDER BY top.s DESC LIMIT " + sampleSize, dimColumn.getName(), externalReferenceColumn.getName(), targetTable.getName(), externalRefTable.getName(), measureColumn.getName(), opValue);
        Statement distinctStatement = this.connectionProvider.getConnection().createStatement();
        Statement seriesStatement = this.connectionProvider.getConnection().createStatement();
        ResultSet distinctValues = distinctStatement.executeQuery(distinctValuesQuery);
        this.updateProgress(0.4f, "Preparing dataset");
        while (distinctValues.next()) {
            title = distinctValues.getString(2);
            if (title == null) continue;
            String groupQuery = String.format("SELECT %2$s, AVG(%3$s) as s  FROM %4$s WHERE %1$s = %5$s GROUP BY %1$s, %2$s ", dimColumn.getName(), timeColumn.getName(), measureColumn.getName(), targetTable.getName(), distinctValues.getLong(1));
            ResultSet series = seriesStatement.executeQuery(groupQuery);
            dataset.addSeries(this.createSeries(series, title));
        }
        seriesStatement.close();
        distinctStatement.close();
        title = "unknow title";
        if (dimColumn.contains(NamesMetadata.class)) {
            title = ((NamesMetadata)dimColumn.getMetadata(NamesMetadata.class)).getTextWithLocale("en").getValue();
        }
        title = title.substring(0, 1).toUpperCase() + title.substring(1);
        return this.getChartImage(title, (XYDataset)dataset);
    }

    private File getChartImage(String title, XYDataset dataset) throws Exception {
        this.updateProgress(0.7f, "Creating chart image");
        JFreeChart chart = this.createChart(dataset, title);
        File image = File.createTempFile("chart", ".jpg");
        ChartUtilities.saveChartAsJPEG((File)image, (JFreeChart)chart, (int)2000, (int)1000);
        return image;
    }

    private JFreeChart createChart(XYDataset dataset, String title) {
        ChartFactory.setChartTheme((ChartTheme)new StandardChartTheme("JFree/Shadow", true));
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Time", (String)"Value", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setBackgroundAlpha(0.7f);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setDrawSeriesLineAsPath(true);
        }
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy"));
        return chart;
    }

    private TimeSeries createSeries(ResultSet rs, String title) throws Exception {
        TimeSeries s1 = new TimeSeries((Comparable)((Object)title));
        while (rs.next()) {
            s1.add((RegularTimePeriod)new Year(rs.getInt(1)), rs.getDouble(2));
        }
        return s1;
    }

    public static class StorageRemover
    implements ResourceRemover {
        private static StorageRemover remover = new StorageRemover();

        public static StorageRemover getInstance() {
            return remover;
        }

        public void onRemove(Resource resource) throws Exception {
            IClient client = new StorageClient(TopRatingChartCreatorWorker.SERVICE_CLASS, TopRatingChartCreatorWorker.SERVICE_NAME, "TDM", AccessType.SHARED, MemoryType.PERSISTENT).getClient();
            client.remove(((InternalURI)resource).getFileId());
        }
    }
}

