/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.view.maps;

import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import java.awt.Color;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.leaf.Range;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.mapping.PostgreSQLModelMapper;
import org.gcube.data.analysis.tabulardata.model.mapping.SQLModelMapper;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.view.maps.GenerateMapFactory;
import org.gcube.data.analysis.tabulardata.operation.view.maps.GeoPublishingConfiguration;
import org.gcube.data.analysis.tabulardata.operation.view.maps.NotSupportedGeometryShapeException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.iso.GcubeISOMetadata;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.gcube.spatial.data.gis.is.GeoServerDescriptor;
import org.gcube.spatial.data.gis.model.report.PublishResponse;
import org.gcube.spatial.data.gis.model.report.Report;
import org.gcube.spatial.data.gis.symbology.ClassStyleDef;
import org.gcube.spatial.data.gis.symbology.GeometryType;
import org.gcube.spatial.data.gis.symbology.StyleUtils;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.TopologyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateMapWorker
extends ResourceCreatorWorker {
    private static Logger logger = LoggerFactory.getLogger(GenerateMapWorker.class);
    private static SQLModelMapper sqlModelMapper = new PostgreSQLModelMapper();
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connProvider;
    private GISInterface gisInterface;
    private GeoPublishingConfiguration geoConfig;
    private Table targetTable;
    private Column geometryColumn;
    private GeometryType geometryType;
    private String layerTitle;
    private List<String> publishedStyles = new ArrayList<String>();
    private List<Column> toCreateFeatures = new ArrayList<Column>();
    private String remoteTable = null;
    private Map<ColumnLocalId, String> fixedColumnLabels;
    private PublishResponse publishResponse;
    private String metaAbstract = "Layer generated via Tabular Data Management Service.";
    private String metaPurpose = "The layer has been generated in order to exploit TDM features";
    private String user;
    private String metaCredits = "The map has been generated via gCube infrastructure.";
    private List<String> metaKeywords = new ArrayList<String>();

    public GenerateMapWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connProvider, GeoPublishingConfiguration geoConfig) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connProvider = connProvider;
        this.geoConfig = geoConfig;
        this.gisInterface = geoConfig.getGis();
    }

    protected ResourcesResult execute() throws WorkerException, OperationAbortedException {
        boolean removeTable = false;
        boolean removeStyles = false;
        boolean removeLayer = false;
        try {
            this.updateProgress(0.1f, "Initializing");
            this.initParameters();
            this.updateProgress(0.2f, "Creating table on remote GIS DB");
            this.checkAborted();
            this.transferTable();
            removeTable = true;
            this.updateProgress(0.7f, "Creating style(s)");
            this.checkAborted();
            this.createStyles();
            removeStyles = true;
            this.updateProgress(0.8f, "Publishing layer");
            this.checkAborted();
            this.createLayer();
            if (this.publishResponse.getDataOperationResult().equals((Object)Report.OperationState.ERROR)) {
                logger.error("Unable to publish layer " + this.publishResponse);
                throw new WorkerException("Unable to create feature type");
            }
            removeLayer = true;
            if (this.publishResponse.getMetaOperationResult().equals((Object)Report.OperationState.ERROR)) {
                logger.error("Unable to publish layer metadata " + this.publishResponse);
                throw new WorkerException("Unable to create layer metadata");
            }
            this.updateProgress(0.9f, "Finalizing");
            String metaUUID = this.publishResponse.getPublishedMetadata().getFileIdentifier();
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(metaUUID)), this.layerTitle + " layer", "GIS representation of this TR.", ResourceType.MAP));
        }
        catch (WorkerException e) {
            this.cleanup(removeTable, removeStyles, removeLayer);
            throw e;
        }
        catch (OperationAbortedException e) {
            this.cleanup(removeTable, removeStyles, removeLayer);
            throw e;
        }
        catch (Throwable t) {
            this.cleanup(removeTable, removeStyles, removeLayer);
            logger.error("Unexpected exception", t);
            logger.error("Current Geoserver : " + this.gisInterface.getCurrentGeoServerDescriptor());
            try {
                logger.error("Current Geonetwork : " + this.gisInterface.getGeoNetworkReader().getConfiguration());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error("Current configuration : " + this.geoConfig);
            throw new WorkerException(t.getMessage(), t);
        }
    }

    private void initParameters() throws WorkerException {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        boolean useView = (Boolean)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.useView, (OperationInvocation)this.getSourceInvocation());
        if (useView && this.targetTable.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)this.targetTable.getMetadata(DatasetViewTableMetadata.class);
            this.targetTable = this.cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
        }
        this.fixedColumnLabels = GenerateMapWorker.curateLabels(this.targetTable);
        Map params = this.getSourceInvocation().getParameterInstances();
        this.layerTitle = (String)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.mapName, (OperationInvocation)this.getSourceInvocation());
        this.toCreateFeatures.addAll(GenerateMapFactory.getSelectedFeatureTypes(this.getSourceInvocation(), this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId()), this.cubeManager));
        if (params.containsKey(GenerateMapFactory.toUseGeometry.getIdentifier())) {
            this.geometryColumn = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.toUseGeometry, (OperationInvocation)this.getSourceInvocation())).getColumnId());
        } else {
            for (Column col : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
                if (!(col.getDataType() instanceof org.gcube.data.analysis.tabulardata.model.datatype.GeometryType)) continue;
                this.geometryColumn = col;
                break;
            }
        }
        try {
            this.geometryType = GenerateMapFactory.getGeometryType(this.targetTable, this.geometryColumn, this.connProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to detect geometry type");
        }
        catch (NotSupportedGeometryShapeException e) {
            throw new WorkerException(e.getMessage());
        }
        this.metaAbstract = (String)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.metaAbstract, (OperationInvocation)this.getSourceInvocation());
        this.metaPurpose = (String)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.metaPurpose, (OperationInvocation)this.getSourceInvocation());
        this.user = (String)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.user, (OperationInvocation)this.getSourceInvocation());
        this.metaCredits = (String)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.metaCredits, (OperationInvocation)this.getSourceInvocation());
        if (params.containsKey(GenerateMapFactory.keywords.getIdentifier())) {
            Object toAddKeys = params.get(GenerateMapFactory.keywords.getIdentifier());
            if (toAddKeys instanceof String) {
                this.metaKeywords.add((String)toAddKeys);
            } else {
                for (String key : (Iterable)toAddKeys) {
                    this.metaKeywords.add(key);
                }
            }
        }
        this.metaKeywords.addAll(this.geoConfig.getParams().getKeywords());
    }

    private void transferTable() throws WorkerException {
        Connection localConn = null;
        Statement localStmt = null;
        ResultSet rs = null;
        Connection postgisConn = null;
        Statement postgisStmt = null;
        PreparedStatement psInsert = null;
        try {
            String newTableName = GenerateMapWorker.randomizeString("tdm");
            String createTableStmt = GenerateMapWorker.getCreateTableStmt(newTableName, this.targetTable, this.geoConfig.getParams().getGeometryFieldName(), this.geometryColumn, this.fixedColumnLabels);
            postgisConn = DriverManager.getConnection(this.geoConfig.getPostgisUrl(), this.geoConfig.getPostgisUser(), this.geoConfig.getPostgisPwd());
            postgisConn.setAutoCommit(false);
            postgisStmt = postgisConn.createStatement();
            logger.debug("Create table command : " + createTableStmt);
            postgisStmt.execute(createTableStmt);
            localConn = this.connProvider.getConnection();
            localStmt = localConn.createStatement();
            List cols = this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class});
            rs = localStmt.executeQuery(String.format("Select %s from %s", OperationHelper.getColumnNamesSnippet((Collection)cols), this.targetTable.getName()));
            String insertStmt = GenerateMapWorker.getInsertStmt(newTableName, this.targetTable, this.geoConfig.getParams().getGeometryFieldName(), this.geometryColumn, this.fixedColumnLabels);
            logger.debug("Insert stmt : " + insertStmt);
            psInsert = postgisConn.prepareStatement(insertStmt);
            while (rs.next()) {
                for (int i = 0; i < cols.size(); ++i) {
                    psInsert.setObject(i + 1, rs.getObject(i + 1));
                }
                psInsert.executeUpdate();
            }
            postgisConn.commit();
            this.remoteTable = newTableName;
        }
        catch (Exception e) {
            try {
                logger.error("Unable to transfer table, configuration is " + this.geoConfig, (Throwable)e);
                throw new WorkerException("Unable to copy table to Geoserver's DB");
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(localStmt);
                DbUtils.closeQuietly(localConn);
                DbUtils.closeQuietly(postgisStmt);
                DbUtils.closeQuietly(psInsert);
                DbUtils.closeQuietly(postgisConn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)localStmt);
        DbUtils.closeQuietly((Connection)localConn);
        DbUtils.closeQuietly((Statement)postgisStmt);
        DbUtils.closeQuietly((Statement)psInsert);
        DbUtils.closeQuietly((Connection)postgisConn);
    }

    private void createStyles() throws WorkerException {
        for (Column col : this.toCreateFeatures) {
            try {
                Number max;
                Number min;
                Range range;
                String styleName = GenerateMapWorker.randomizeString(OperationHelper.retrieveColumnLabel((Column)col)).replaceAll("[^a-zA-Z0-9]", "_");
                String attribute = this.fixedColumnLabels.get(col.getLocalId());
                Color c1 = Color.red;
                Color c2 = Color.yellow;
                String sld = null;
                if (col.getDataType() instanceof NumericType) {
                    range = this.getMinMax(col);
                    min = Float.valueOf(((TDNumeric)range.getMinimum()).getValue().floatValue());
                    max = Float.valueOf(((TDNumeric)range.getMaximum()).getValue().floatValue());
                    sld = StyleUtils.createStyle((String)styleName, (String)attribute, (int)5, (Color)c1, (Color)c2, Float.class, (Object)max, (Object)min, (GeometryType)this.geometryType);
                } else if (col.getDataType() instanceof IntegerType) {
                    range = this.getMinMax(col);
                    min = ((TDInteger)range.getMinimum()).getValue();
                    max = ((TDInteger)range.getMaximum()).getValue();
                    sld = StyleUtils.createStyle((String)styleName, (String)attribute, (int)5, (Color)c1, (Color)c2, Integer.class, (Object)max, (Object)min, (GeometryType)this.geometryType);
                } else {
                    ArrayList<ClassStyleDef> classes = this.getDiscreteClasses(col);
                    sld = StyleUtils.createStyle((String)styleName, (String)attribute, classes, (Color)c1, (Color)c2, (GeometryType)this.geometryType);
                }
                PublishResponse resp = this.gisInterface.publishStyle(sld, styleName);
                if (resp.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE)) {
                    this.publishedStyles.add(styleName);
                    continue;
                }
                throw new Exception("Error while publishing style : " + resp.getDataOperationMessages());
            }
            catch (Exception e) {
                logger.debug("Error while generating styles.", (Throwable)e);
            }
        }
        if (this.publishedStyles.size() == 0) {
            throw new WorkerException("No styles generated");
        }
    }

    private void createLayer() throws WorkerException {
        try {
            GSFeatureTypeEncoder fte = new GSFeatureTypeEncoder();
            fte.setEnabled(true);
            fte.setLatLonBoundingBox(-180.0, -90.0, 180.0, 90.0, this.geoConfig.getParams().getCrs());
            fte.setName(this.remoteTable);
            fte.setNativeCRS(this.geoConfig.getParams().getCrs());
            GSLayerEncoder le = new GSLayerEncoder();
            le.setDefaultStyle(this.publishedStyles.get(0));
            le.setEnabled(true);
            GcubeISOMetadata meta = this.fillMeta();
            this.publishResponse = this.gisInterface.publishDBTable(this.geoConfig.getParams().getWorkspace(), this.geoConfig.getParams().getDatastore(), fte, le, meta.getMetadata(), this.geoConfig.getParams().getgNCategory(), this.geoConfig.getParams().getgNStyleSheet(), LoginLevel.DEFAULT, false);
        }
        catch (Exception e) {
            throw new WorkerException("Unable to publish GIS Resources", (Throwable)e);
        }
    }

    private GcubeISOMetadata fillMeta() throws Exception {
        GcubeISOMetadata meta = new GcubeISOMetadata();
        meta.setAbstractField(this.metaAbstract);
        meta.setCreationDate(new Date(System.currentTimeMillis()));
        meta.setExtent((DefaultExtent)DefaultExtent.WORLD);
        meta.setGeometricObjectType(GeometricObjectType.SURFACE);
        meta.setPresentationForm(PresentationForm.MAP_DIGITAL);
        meta.setPurpose(this.metaPurpose);
        meta.setTitle(this.layerTitle);
        meta.setTopologyLevel(TopologyLevel.GEOMETRY_ONLY);
        meta.setUser(this.user);
        meta.addCredits(this.metaCredits);
        Thesaurus generalThesaurus = (Thesaurus)meta.getConfig().getThesauri().get("General");
        for (String keyword : this.metaKeywords) {
            meta.addKeyword(keyword, generalThesaurus);
        }
        meta.addTopicCategory(TopicCategory.BIOTA);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range getMinMax(Column toCheckColumn) throws SQLException {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block3: {
            Range range;
            conn = null;
            stmt = null;
            try {
                conn = this.connProvider.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(String.format("SELECT max(%1$s) as max,min(%1$s) as min from %2$s", toCheckColumn.getName(), this.targetTable.getName()));
                rs.next();
                if (!(toCheckColumn.getDataType() instanceof NumericType)) break block3;
                range = new Range((TDTypeValue)new TDNumeric(Float.valueOf(rs.getFloat("min"))), (TDTypeValue)new TDNumeric(Float.valueOf(rs.getFloat("max"))));
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)conn);
            return range;
        }
        Range range = new Range((TDTypeValue)new TDInteger(Integer.valueOf(rs.getInt("min"))), (TDTypeValue)new TDInteger(Integer.valueOf(rs.getInt("max"))));
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ClassStyleDef> getDiscreteClasses(Column toCheckColumn) throws SQLException {
        ArrayList<ClassStyleDef> arrayList;
        Connection conn = null;
        Statement stmt = null;
        try {
            ArrayList<ClassStyleDef> toReturn = new ArrayList<ClassStyleDef>();
            conn = this.connProvider.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(String.format("SELECT distinct(%s) as values from %s", toCheckColumn.getName(), this.targetTable.getName()));
            while (rs.next()) {
                toReturn.add(new ClassStyleDef((Object)rs.getString(1)));
            }
            arrayList = toReturn;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(stmt);
            DbUtils.closeQuietly(conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(boolean removeTable, boolean removeStyles, boolean removeLayer) {
        block7: {
            if (!removeTable) break block7;
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(this.geoConfig.getPostgisUrl(), this.geoConfig.getPostgisUser(), this.geoConfig.getPostgisPwd());
                conn.createStatement().execute("DROP " + this.remoteTable);
            }
            catch (Exception e) {
                try {
                    logger.error("Unable to delete table " + this.remoteTable, (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(conn);
                    throw throwable;
                }
                DbUtils.closeQuietly((Connection)conn);
            }
            DbUtils.closeQuietly((Connection)conn);
            if (removeStyles) {
                GeoServerDescriptor currentDesc = this.gisInterface.getCurrentGeoServerDescriptor();
                for (String style : this.publishedStyles) {
                    this.gisInterface.deleteStyle(style, (AbstractGeoServerDescriptor)currentDesc);
                }
                if (removeLayer) {
                    this.gisInterface.deleteLayer(this.geoConfig.getParams().getWorkspace(), this.remoteTable, null, (AbstractGeoServerDescriptor)currentDesc, LoginLevel.DEFAULT);
                }
            }
        }
    }

    private static String randomizeString(String prefix) {
        return prefix + UUID.randomUUID().toString().replace("-", "");
    }

    private static String getCreateTableStmt(String newTableName, Table t, String geomName, Column geometryCol, Map<ColumnLocalId, String> toUseLabels) {
        StringBuilder toReturn = new StringBuilder("CREATE TABLE " + newTableName + " (");
        for (Column col : t.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            String toSetColName = col.getLocalId().equals((Object)geometryCol.getLocalId()) ? geomName : toUseLabels.get(col.getLocalId());
            String dataDefinition = col.getDataType() instanceof org.gcube.data.analysis.tabulardata.model.datatype.GeometryType ? "geometry" : sqlModelMapper.translateDataTypeToSQL(col.getDataType());
            toReturn.append(String.format("%s %s,", toSetColName, dataDefinition));
        }
        toReturn.append(")");
        toReturn.deleteCharAt(toReturn.lastIndexOf(","));
        return toReturn.toString();
    }

    private static String getInsertStmt(String tableName, Table t, String geomName, Column geometryCol, Map<ColumnLocalId, String> toUseLabels) {
        StringBuilder toReturn = new StringBuilder("INSERT INTO " + tableName + " (");
        StringBuilder valuePlaceholders = new StringBuilder(" VALUES (");
        for (Column col : t.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            toReturn.append(col.getLocalId().equals((Object)geometryCol.getLocalId()) ? geomName : toUseLabels.get(col.getLocalId()));
            toReturn.append(",");
            valuePlaceholders.append("?,");
        }
        toReturn.append(")");
        toReturn.deleteCharAt(toReturn.lastIndexOf(","));
        valuePlaceholders.deleteCharAt(valuePlaceholders.lastIndexOf(","));
        return toReturn.toString() + valuePlaceholders.toString() + ")";
    }

    private static Map<ColumnLocalId, String> curateLabels(Table table) {
        HashMap<ColumnLocalId, String> toReturn = new HashMap<ColumnLocalId, String>();
        HashMap<String, Integer> clashCounter = new HashMap<String, Integer>();
        for (Column col : table.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            String originalLabel = OperationHelper.retrieveColumnLabel((Column)col);
            String fixed = originalLabel.replaceAll("\\W", "_").toLowerCase();
            if (clashCounter.containsKey(fixed)) {
                clashCounter.put(fixed, (Integer)clashCounter.get(fixed) + 1);
                fixed = fixed + "_" + clashCounter.get(fixed);
            } else {
                clashCounter.put(fixed, 1);
            }
            toReturn.put(col.getLocalId(), fixed);
        }
        return toReturn;
    }
}

