package org.gcube.data.analysis.tabulardata.service.operation;

import java.util.List;

import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchOperationException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
public interface OperationInterface {
	
	public List<OperationDefinition> getCapabilities();
	
	public OperationDefinition getCapability(long operationId) throws NoSuchOperationException;

	public Task execute(OperationExecution invocation, TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, InvalidTabularResourceException, InvalidInvocationException;
	
	public Table rollbackToTable(TabularResourceId tabularResourceId, TableId tableId) throws NoSuchTabularResourceException, NoSuchTableException;
	 
	public List<Task> getTasks(TabularResourceId tabulaResourceId) throws NoSuchTabularResourceException;
	
	public Task getTask(TaskId taskId) throws NoSuchTaskException;
	
}
