/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.Job;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskJobImpl;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskObserver;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskUpdater;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJob;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.td.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.td.commons.webservice.types.TaskInfo;

public class DefaultTask
implements Task,
TaskObserver,
Serializable {
    private static final long serialVersionUID = 1L;
    private TaskUpdater updater;
    private TaskManagerProxy taskManager;
    private TaskInfo taskInfo;

    protected DefaultTask(TaskInfo taskInfo, TaskManagerProxy taskManager, TaskUpdater updater) {
        this.taskInfo = taskInfo;
        this.taskManager = taskManager;
        this.updater = updater;
        this.updater.registerObserver(this);
    }

    public float getProgress() {
        this.updater.checkUpdate();
        return this.getTaskJobs().get(0).getProgress();
    }

    public ActivityStatus getStatus() {
        this.updater.checkUpdate();
        return this.taskInfo.getStatus();
    }

    public OperationInvocation getSourceInvocation() {
        return this.getTaskJobs().get(0).getSourceInvocation();
    }

    public JobResult getResult() {
        this.updater.checkUpdate();
        return this.taskInfo.getJobResult();
    }

    public Task.TaskId getId() {
        return new Task.TaskId(this.taskInfo.getIdentifier());
    }

    public List<TaskJob> getTaskJobs() {
        this.updater.checkUpdate();
        ArrayList taskJobs = Lists.newArrayList();
        for (Job job : this.taskInfo.getJobs()) {
            taskJobs.add(new TaskJobImpl(job));
        }
        return taskJobs;
    }

    public Date getStartTime() {
        return this.taskInfo.getStartTime().getTime();
    }

    public Date getEndTime() {
        this.updater.checkUpdate();
        return this.taskInfo.getEndTime().getTime();
    }

    public String getInvokerUsername() {
        return "";
    }

    public List<TabularResourceId> getCollateralTabularResourceIds() {
        return null;
    }

    public void abort() {
        try {
            this.taskManager.abort(this.getId().getValue());
        }
        catch (NoSuchTaskException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void notify(TaskInfo task) {
        this.taskInfo = task;
    }

    @Override
    public String getObserverIdentifier() {
        return this.taskInfo.getIdentifier();
    }
}

