package org.gcube.data.analysis.tabulardata.service.impl;

import java.util.HashMap;
import java.util.Map;

import org.gcube.data.analysis.tabulardata.service.TabularDataService;

public class TabularDataServiceFactory {

	private static Map<String, TabularDataService> userServiceMap = new HashMap<String, TabularDataService>();
	
	private TabularDataServiceFactory(){}
	
	public static TabularDataService getService(String user){
		if (!userServiceMap.containsKey(user)){
			TabularDataService service = new TabularDataServiceImpl(user);
			userServiceMap.put(user, service);
			return service;
		}
		else return userServiceMap.get(user);
	}
}
