package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import java.io.Serializable;

import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.Job;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJob;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJobClassifier;

public class TaskJobImpl implements TaskJob, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Job job;
	
	public TaskJobImpl(Job job){
		this.job = job;
	}
	
	@Override
	public float getProgress() {
		return job.getProgress();
	}

	@Override
	public ActivityStatus getStatus() {
		return job.getStatus();
	}

	@Override
	public OperationInvocation getSourceInvocation() {
		return job.getSourceInvocation();
	}

	@Override
	public JobResult getResult() {
		return job.getResult();
	}

	@Override
	public TaskJobClassifier getClassifier() {
		return TaskJobClassifier.PROCESSING;
	}

}
