package org.gcube.data.analysis.tabulardata.service.impl.tabular;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJobClassifier;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.td.commons.webservice.types.HistoryData;

public class HistoryStepImpl implements HistoryStep {

	private HistoryData historyData;
	
	protected HistoryStepImpl(HistoryData historyData){
		this.historyData = historyData;
	}
	
	@Override
	public OperationInvocation getOperationInvocation() {
		return historyData.getInvocation();
	}

	@Override
	public Table getResultTable() {
		return historyData.getResultTable();
	}

	@Override
	public TaskJobClassifier getOperationClassifier() {
		return TaskJobClassifier.PROCESSING;
	}

}
