/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl;

import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.impl.operation.OperationInterfaceImpl;
import org.gcube.data.analysis.tabulardata.service.impl.query.QueryInterfaceImpl;
import org.gcube.data.analysis.tabulardata.service.impl.tabular.TabularResourceImpl;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterface;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularDataServiceImpl
implements TabularDataService {
    private Logger logger = LoggerFactory.getLogger(TabularDataServiceImpl.class);
    private String user;
    private QueryInterface queryInterface = new QueryInterfaceImpl();
    private TabularResourceInterface tabularResourceInterface;
    private OperationInterface operationInterface = new OperationInterfaceImpl();

    protected TabularDataServiceImpl(String user) {
        this.user = user;
        this.tabularResourceInterface = new TabularResourceImpl(user);
    }

    public Table getTable(TableId tableId) throws NoSuchTableException {
        return this.queryInterface.getTable(tableId);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter, order);
    }

    public int getQueryLenght(TableId tableId, QueryFilter filter) throws NoSuchTableException {
        return this.queryInterface.getQueryLenght(tableId, filter);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, order);
    }

    public String queryAsJson(TableId tableId, QueryPage page) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page);
    }

    public List<TabularResource> getTabularResources() {
        return this.tabularResourceInterface.getTabularResources();
    }

    public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        return this.tabularResourceInterface.getTabularResource(id);
    }

    public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        this.tabularResourceInterface.removeTabularResource(id);
    }

    public TabularResource cloneTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        return this.tabularResourceInterface.cloneTabularResource(id);
    }

    public TabularResource cloneTabularResource(TabularResourceId id, TableId lastTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        return this.tabularResourceInterface.cloneTabularResource(id, lastTableId);
    }

    public TabularResource createTabularResource() {
        return this.tabularResourceInterface.createTabularResource();
    }

    public Table getLastTable(TabularResourceId id) throws NoSuchTabularResourceException, InvalidTabularResourceException {
        return this.tabularResourceInterface.getLastTable(id);
    }

    public List<EligibleOperation> getCapabilities() {
        return this.operationInterface.getCapabilities();
    }

    public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, InvalidTabularResourceException {
        return this.operationInterface.getCapabilities(tabularResourceId);
    }

    public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId, ColumnLocalId columnId) throws NoSuchTabularResourceException, InvalidTabularResourceException, NoSuchColumnException {
        return this.operationInterface.getCapabilities(tabularResourceId, columnId);
    }

    public Task execute(OperationInvocation invocation, TabularResourceId targetTabularResourceId) throws NoSuchTabularResourceException, InvalidTabularResourceException, InvalidInvocationException {
        return this.operationInterface.execute(invocation, targetTabularResourceId);
    }

    public Table rollbackToTable(TabularResourceId tabularResourceId, TableId toTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        return this.operationInterface.rollbackToTable(tabularResourceId, toTableId);
    }

    public List<Task> getTasks(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
        return this.operationInterface.getTasks(tabularResourceId);
    }

    public Task getTask(Task.TaskId operationId, TabularResourceId tabularResourceId) throws NoSuchTaskException, NoSuchTabularResourceException {
        return this.operationInterface.getTask(operationId, tabularResourceId);
    }
}

