/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.tabular;

import java.util.List;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.HistoryManagerProxy;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TabularResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.impl.tabular.TabularResourceObject;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularResourceImpl
implements TabularResourceInterface {
    private static Logger logger = LoggerFactory.getLogger(TabularResourceImpl.class);
    private HistoryManagerProxy historyManager = (HistoryManagerProxy)AbstractPlugin.history().build();
    private TabularResourceManagerProxy tabularResourceProxy = (TabularResourceManagerProxy)AbstractPlugin.tabularResource().build();
    private String user;

    public TabularResourceImpl(String user) {
        this.user = user;
    }

    public List<TabularResource> getTabularResources() {
        System.out.println("calling get tabularResources with user " + this.user);
        return TabularResourceObject.getAll(this.user);
    }

    public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        return TabularResourceObject.get(this.user, id);
    }

    public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
    }

    public TabularResource cloneTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        return null;
    }

    public TabularResource cloneTabularResource(TabularResourceId id, TableId lastTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        return null;
    }

    public TabularResource createTabularResource() {
        long tabularResourceId;
        try {
            tabularResourceId = this.tabularResourceProxy.createTabularResource();
        }
        catch (Exception e) {
            logger.error("error creating tabule resource on the service", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            return TabularResourceObject.create(this.user, new TabularResourceId(tabularResourceId));
        }
        catch (Exception e) {
            logger.error("error creating tabule resource on Workspace, rolling back", (Throwable)e);
            try {
                this.removeTabularResource(new TabularResourceId(tabularResourceId));
            }
            catch (NoSuchTabularResourceException e1) {
                logger.error("error rolling back");
                throw new RuntimeException("error rolling back", e);
            }
            throw new RuntimeException(e);
        }
    }

    public Table getLastTable(TabularResourceId id) throws NoSuchTabularResourceException, InvalidTabularResourceException {
        try {
            return this.historyManager.getLastTable(id.getValue());
        }
        catch (org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException e) {
            logger.error("tabular resource with id {} not found", (Object)id);
            throw new NoSuchTabularResourceException(id);
        }
    }
}

