package org.gcube.data.analysis.tabulardata.service.impl.tabular;

import java.util.List;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.HistoryManagerProxy;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TabularResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin.history;
import static org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin.tabularResource;

public class TabularResourceImpl implements TabularResourceInterface {

	private static Logger logger = LoggerFactory.getLogger(TabularResourceImpl.class);
	
	private HistoryManagerProxy historyManager = history().build();
	private TabularResourceManagerProxy tabularResourceProxy = tabularResource().build();
	
	private String user;
	
	
	public TabularResourceImpl(String user) {
		super();
		this.user = user;
	}

	@Override
	public List<TabularResource> getTabularResources() {
		System.out.println("calling get tabularResources with user "+user);
		return TabularResourceObject.getAll(user);
	}

	@Override
	public TabularResource getTabularResource(TabularResourceId id)
			throws NoSuchTabularResourceException {
		return TabularResourceObject.get(user, id);
	}

	@Override
	public void removeTabularResource(TabularResourceId id)
			throws NoSuchTabularResourceException {
		// TODO Auto-generated method stub

	}

	@Override
	public TabularResource cloneTabularResource(TabularResourceId id)
			throws NoSuchTabularResourceException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TabularResource cloneTabularResource(TabularResourceId id,
			TableId lastTableId) throws NoSuchTabularResourceException,
			NoSuchTableException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TabularResource createTabularResource() {
		long tabularResourceId;
		try {
			tabularResourceId = tabularResourceProxy.createTabularResource();
		} catch (Exception e) {
			logger.error("error creating tabule resource on the service",e);
			throw new RuntimeException(e);
		}
		try{
			return TabularResourceObject.create(user, new TabularResourceId(tabularResourceId));
		}catch (Exception e) {
			logger.error("error creating tabule resource on Workspace, rolling back",e);
			try {
				this.removeTabularResource(new TabularResourceId(tabularResourceId));
			} catch (NoSuchTabularResourceException e1) {
				logger.error("error rolling back");
				throw new RuntimeException("error rolling back",e);
			}
			
			throw new RuntimeException(e);
		}

	}

	@Override
	public Table getLastTable(TabularResourceId id)
			throws NoSuchTabularResourceException,
			InvalidTabularResourceException {
		try {
			return historyManager.getLastTable(id.getValue());
		} catch (org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException e) {
			logger.error("tabular resource with id {} not found",id);
			throw new NoSuchTabularResourceException(id);
		}
	}
	
}
