/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskObserver;

public class TaskUpdater
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long MILLIS_FOR_UPDATE = 3000L;
    private Long timestamp = 0L;
    private Map<String, TaskObserver> observers = new HashMap<String, TaskObserver>();
    private String scope;

    public TaskUpdater(String scope) {
        this.scope = scope;
    }

    void registerObserver(TaskObserver observer) {
        this.observers.put(observer.getObserverIdentifier(), observer);
    }

    void unregisterObserver(String observerIdentifier) {
        this.observers.remove(observerIdentifier);
    }

    boolean checkUpdate() {
        long actualTimestamp = System.currentTimeMillis();
        if (!this.observers.isEmpty() && actualTimestamp - this.timestamp > 3000L) {
            this.timestamp = System.currentTimeMillis();
            this.notifiesObservers(this.callUpdate());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskInfo> callUpdate() {
        String actualScope = ScopeProvider.instance.get();
        try {
            ScopeProvider.instance.set(this.scope);
            TaskManagerProxy proxy = (TaskManagerProxy)AbstractPlugin.tasks().build();
            List tasks = proxy.get(this.observers.keySet().toArray(new String[this.observers.size()]));
            if (tasks.size() < this.observers.size()) {
                this.observers = new HashMap<String, TaskObserver>();
            }
            List list = tasks;
            return list;
        }
        finally {
            if (actualScope != null) {
                ScopeProvider.instance.set(actualScope);
            }
        }
    }

    private void notifiesObservers(List<TaskInfo> tasks) {
        for (TaskInfo task : tasks) {
            this.observers.get(task.getIdentifier()).notify(task);
        }
    }
}

