/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl;

import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.HistoryNotFoundException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.query.parameters.group.QueryGroup;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QuerySelect;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchOperationException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTemplateException;
import org.gcube.data.analysis.tabulardata.service.exception.TemplateNotCompatibleException;
import org.gcube.data.analysis.tabulardata.service.impl.operation.OperationInterfaceImpl;
import org.gcube.data.analysis.tabulardata.service.impl.query.QueryInterfaceImpl;
import org.gcube.data.analysis.tabulardata.service.impl.tabular.TabularResourceImpl;
import org.gcube.data.analysis.tabulardata.service.impl.template.TemplateInterfaceImpl;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterface;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStepId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;
import org.gcube.data.analysis.tabulardata.service.template.TemplateId;
import org.gcube.data.analysis.tabulardata.service.template.TemplateInterface;

public class TabularDataServiceImpl
implements TabularDataService {
    private QueryInterface queryInterface = new QueryInterfaceImpl();
    private TabularResourceInterface tabularResourceInterface = new TabularResourceImpl();
    private OperationInterface operationInterface = new OperationInterfaceImpl();
    private TemplateInterface templateInterface = new TemplateInterfaceImpl();

    public List<TabularResource> getTabularResources() {
        return this.tabularResourceInterface.getTabularResources();
    }

    public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        return this.tabularResourceInterface.getTabularResource(id);
    }

    public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        this.tabularResourceInterface.removeTabularResource(id);
    }

    public Table getTable(TableId tableId) throws NoSuchTableException {
        return this.queryInterface.getTable(tableId);
    }

    public TabularResource createTabularResource() {
        return this.tabularResourceInterface.createTabularResource();
    }

    public Table getLastTable(TabularResourceId id) throws NoSuchTabularResourceException, InvalidTabularResourceException, NoSuchTableException {
        return this.tabularResourceInterface.getLastTable(id);
    }

    public List<OperationDefinition> getCapabilities() {
        return this.operationInterface.getCapabilities();
    }

    public OperationDefinition getCapability(long operationId) throws NoSuchOperationException {
        return this.operationInterface.getCapability(operationId);
    }

    public Task execute(OperationExecution invocation, TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, NoSuchOperationException {
        return this.operationInterface.execute(invocation, tabularResourceId);
    }

    public Task executeBatch(List<OperationExecution> invocations, TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, NoSuchOperationException {
        return this.operationInterface.executeBatch(invocations, tabularResourceId);
    }

    public Task rollbackTo(TabularResourceId tabularResourceId, HistoryStepId historyStepId) throws NoSuchTabularResourceException, HistoryNotFoundException {
        return this.operationInterface.rollbackTo(tabularResourceId, historyStepId);
    }

    public List<Task> getTasks(TabularResourceId tabulaResourceId) throws NoSuchTabularResourceException {
        return this.operationInterface.getTasks(tabulaResourceId);
    }

    public Task getTask(TaskId taskId) throws NoSuchTaskException {
        return this.operationInterface.getTask(taskId);
    }

    public List<Task> getTasks(TabularResourceId tabulaResourceId, TaskStatus status) throws NoSuchTabularResourceException {
        return this.operationInterface.getTasks(tabulaResourceId, status);
    }

    public int getQueryLenght(TableId tableId, QueryFilter filter) throws NoSuchTableException {
        return this.queryInterface.getQueryLenght(tableId, filter);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter, order);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QuerySelect select) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, select);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryGroup group) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, group);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order, QuerySelect select) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter, order, select);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order, QuerySelect select, QueryGroup group) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter, order, select, group);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QuerySelect select) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter, select);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QuerySelect select, QueryGroup group) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter, select, group);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryGroup group) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter, group);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order, QuerySelect select, QueryGroup group) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, order, select, group);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order, QueryGroup group) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, order, group);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order, QuerySelect select) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, order, select);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QuerySelect select, QueryGroup group) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, select, group);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, order);
    }

    public String queryAsJson(TableId tableId, QueryPage page) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page);
    }

    public TabularResource share(TabularResourceId tabularResourceId, AuthorizationToken ... tokens) throws NoSuchTabularResourceException, SecurityException {
        return this.tabularResourceInterface.share(tabularResourceId, tokens);
    }

    public TabularResource unshare(TabularResourceId tabularResourceId, AuthorizationToken ... tokens) throws NoSuchTabularResourceException, SecurityException {
        return this.tabularResourceInterface.unshare(tabularResourceId, tokens);
    }

    public List<TabularResource> getTabularResourcesByType(String type) {
        return this.tabularResourceInterface.getTabularResourcesByType(type);
    }

    public TemplateDescription getTemplate(TemplateId id) throws NoSuchTemplateException {
        return this.templateInterface.getTemplate(id);
    }

    public List<TemplateDescription> getTemplates() {
        return this.templateInterface.getTemplates();
    }

    public TemplateId saveTemplate(String name, String description, String agency, Template template) {
        return this.templateInterface.saveTemplate(name, description, agency, template);
    }

    public TemplateDescription update(TemplateId id, Template template) throws NoSuchTemplateException {
        return this.templateInterface.update(id, template);
    }

    public Task applyTemplate(TemplateId templateId, TabularResourceId tabularResourceId) throws NoSuchTemplateException, NoSuchTabularResourceException, TemplateNotCompatibleException {
        return this.templateInterface.applyTemplate(templateId, tabularResourceId);
    }

    public TemplateDescription share(TemplateId templateId, String ... users) throws NoSuchTemplateException {
        return this.templateInterface.share(templateId, users);
    }

    public TemplateDescription unshare(TemplateId templateId, String ... users) throws NoSuchTemplateException {
        return this.templateInterface.unshare(templateId, users);
    }

    public TemplateDescription remove(TemplateId id) throws NoSuchTemplateException {
        return this.templateInterface.remove(id);
    }

    public Task resubmit(TaskId taskId) throws NoSuchTaskException {
        return this.operationInterface.resubmit(taskId);
    }

    public Task resume(TaskId taskId, Map<String, Object> operationInvocationParameter) throws NoSuchTaskException {
        return this.operationInterface.resume(taskId, operationInvocationParameter);
    }

    public Task resume(TaskId taskId) throws NoSuchTaskException {
        return this.operationInterface.resume(taskId);
    }
}

