/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.tabular;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TabularResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.HistoryData;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.service.impl.tabular.HistoryStepImpl;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularResourceObject
implements org.gcube.data.analysis.tabulardata.service.tabular.TabularResource {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(TabularResourceObject.class);
    private volatile TabularResourceManagerProxy trManager = (TabularResourceManagerProxy)AbstractPlugin.tabularResource().build();
    private TabularResource remoteTabularResource;

    public TabularResourceObject(TabularResource remoteTabularResource) {
        this.remoteTabularResource = remoteTabularResource;
    }

    public <C extends TabularResourceMetadata<?>> C getMetadata(Class<C> metadataType) {
        if (metadataType.equals(NameMetadata.class)) {
            return (C)new NameMetadata(this.remoteTabularResource.getName());
        }
        if (!this.getProperties().containsKey(metadataType.getName())) {
            throw new NoSuchMetadataException(metadataType);
        }
        try {
            return (C)this.retrieveInternalMetadata(metadataType.getName(), this.getProperties().get(metadataType.getName()));
        }
        catch (Exception e) {
            throw new RuntimeException("error instantiating metadata " + metadataType.getName() + " it must implement a void constructor");
        }
    }

    public boolean contains(Class<? extends TabularResourceMetadata<?>> metadataType) {
        if (metadataType.equals(NameMetadata.class)) {
            return true;
        }
        return this.getProperties().containsKey(metadataType.getName());
    }

    public void removeMetadata(Class<? extends TabularResourceMetadata<?>> metadataType) {
        this.getProperties().remove(metadataType.getName());
        this.flush();
    }

    public void setMetadata(TabularResourceMetadata<?> metadata) {
        if (metadata.getClass().equals(NameMetadata.class)) {
            this.remoteTabularResource.setName((String)metadata.getValue());
        } else if (metadata.getValue() != null) {
            this.getProperties().put(metadata.getClass().getName(), (Serializable)metadata.getValue());
        }
        this.flush();
    }

    private <T> TabularResourceMetadata<T> retrieveInternalMetadata(String metadataClassName, T value) throws Exception {
        Constructor<?> constructor = Class.forName(metadataClassName).getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        TabularResourceMetadata trm = (TabularResourceMetadata)constructor.newInstance(new Object[0]);
        trm.setValue(value);
        return trm;
    }

    public Collection<TabularResourceMetadata<?>> getAllMetadata() {
        ArrayList metadata = new ArrayList();
        if (this.getProperties() != null && this.getProperties().size() > 0) {
            for (Map.Entry<String, Serializable> entry : this.getProperties().entrySet()) {
                try {
                    TabularResourceMetadata<Serializable> trm = this.retrieveInternalMetadata(entry.getKey(), entry.getValue());
                    metadata.add(trm);
                }
                catch (Exception e) {
                    throw new RuntimeException("error instantiating metadata " + entry.getKey() + " it must implement a void constructor");
                }
            }
        }
        metadata.add((TabularResourceMetadata<?>)new NameMetadata(this.remoteTabularResource.getName()));
        return metadata;
    }

    public void setAllMetadata(Collection<TabularResourceMetadata<?>> metadata) {
        for (TabularResourceMetadata<?> singleMetadata : metadata) {
            if (singleMetadata.getClass().equals(NameMetadata.class)) {
                this.remoteTabularResource.setName((String)singleMetadata.getValue());
                continue;
            }
            this.getProperties().put(singleMetadata.getClass().getName(), (Serializable)singleMetadata.getValue());
        }
        this.flush();
    }

    public void removeAllMetadata() {
        this.remoteTabularResource.setProperties(new HashMap());
        this.flush();
    }

    public TabularResourceId getId() {
        return new TabularResourceId(this.remoteTabularResource.getId());
    }

    public List<HistoryStep> getHistory() {
        try {
            ArrayList<HistoryStep> historySteps = new ArrayList<HistoryStep>();
            List steps = this.remoteTabularResource.getHistory();
            for (HistoryData step : steps) {
                historySteps.add(new HistoryStepImpl(step));
            }
            return historySteps;
        }
        catch (Exception e) {
            logger.error("error retrievin history for tabular resource id {}", (Object)this.remoteTabularResource.getId());
            throw new RuntimeException(e);
        }
    }

    private Map<String, Serializable> getProperties() {
        return this.remoteTabularResource.getProperties();
    }

    public Calendar getCreationDate() {
        return this.remoteTabularResource.getCreationDate();
    }

    private void flush() {
        try {
            this.trManager.updateTabularResource(this.remoteTabularResource);
        }
        catch (Exception e) {
            new RuntimeException("error updating item properties on server", e);
        }
    }

    public String getTableType() {
        return this.remoteTabularResource.getType();
    }

    public String getOwner() {
        return this.remoteTabularResource.getOwner();
    }

    public List<String> getSharedWithUsers() {
        return this.remoteTabularResource.getSharedWithUsers();
    }

    public List<String> getSharedWithGroup() {
        return this.remoteTabularResource.getSharedWithGroup();
    }

    public boolean isValid() {
        return this.remoteTabularResource.isValid();
    }

    public boolean isFinalized() {
        return this.remoteTabularResource.isFinalized();
    }

    public void finalize() {
        this.remoteTabularResource.finalize(true);
        this.flush();
    }

    public String toString() {
        return this.remoteTabularResource.toString();
    }
}

