/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.operation;

import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.OperationManagerProxy;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.ExecutionFailedException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.HistoryNotFoundException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.BatchOption;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchOperationException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskFactory;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStepId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

public class OperationInterfaceImpl
implements OperationInterface {
    private static OperationManagerProxy operationManager = (OperationManagerProxy)AbstractPlugin.operation().build();
    private static TaskManagerProxy taskManager = (TaskManagerProxy)AbstractPlugin.tasks().build();

    public List<OperationDefinition> getCapabilities() {
        return operationManager.getCapabilities();
    }

    public OperationDefinition getCapability(long operationId) throws NoSuchOperationException {
        try {
            return operationManager.getCapabilities(operationId);
        }
        catch (OperationNotFoundException e) {
            throw new NoSuchOperationException(operationId);
        }
    }

    public Task execute(OperationExecution invocation, TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, NoSuchOperationException {
        try {
            TaskInfo taskInfo = operationManager.execute(tabularResourceId.getValue(), invocation);
            return TaskFactory.getFactory().createTask(taskInfo);
        }
        catch (org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException e) {
            throw new NoSuchTabularResourceException(tabularResourceId);
        }
        catch (OperationNotFoundException e) {
            throw new NoSuchOperationException(0L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void executeSynchMetadataOperation(OperationExecution invocation, TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, NoSuchOperationException, ExecutionFailedException {
        try {
            operationManager.executeSynchMetadataOperation(tabularResourceId.getValue(), invocation);
        }
        catch (org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException e) {
            throw new NoSuchTabularResourceException(tabularResourceId);
        }
        catch (OperationNotFoundException e) {
            throw new NoSuchOperationException(0L);
        }
        catch (ExecutionFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Task executeBatch(List<OperationExecution> invocations, TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, NoSuchOperationException {
        try {
            TaskInfo taskInfo = operationManager.execute(tabularResourceId.getValue(), invocations, BatchOption.NONE);
            return TaskFactory.getFactory().createTask(taskInfo);
        }
        catch (org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException e) {
            throw new NoSuchTabularResourceException(tabularResourceId);
        }
        catch (OperationNotFoundException e) {
            throw new NoSuchOperationException(0L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Task rollbackTo(TabularResourceId tabularResourceId, HistoryStepId historyStepId) throws NoSuchTabularResourceException, HistoryNotFoundException {
        TaskInfo taskInfo;
        try {
            taskInfo = operationManager.rollbackTo(tabularResourceId.getValue(), historyStepId.getValue());
        }
        catch (org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException e) {
            throw new NoSuchTabularResourceException(tabularResourceId);
        }
        return TaskFactory.getFactory().createTask(taskInfo);
    }

    public List<Task> getTasks(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
        return TaskFactory.getFactory().getTasks(tabularResourceId, null);
    }

    public Task getTask(TaskId taskId) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException {
        return TaskFactory.getFactory().getTask(taskId);
    }

    public List<Task> getTasks(TabularResourceId tabularResourceId, TaskStatus status) throws NoSuchTabularResourceException {
        return TaskFactory.getFactory().getTasks(tabularResourceId, status);
    }

    public Task resubmit(TaskId taskId) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException {
        try {
            TaskInfo taskInfo = taskManager.resubmit(taskId.getValue());
            return TaskFactory.getFactory().createTask(taskInfo);
        }
        catch (NoSuchTaskException e) {
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException(taskId);
        }
    }

    public Task resume(TaskId taskId, Map<String, Object> operationInvocationParameter) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException {
        try {
            TaskInfo taskInfo = taskManager.resume(taskId.getValue(), operationInvocationParameter);
            return TaskFactory.getFactory().createTask(taskInfo);
        }
        catch (NoSuchTaskException e) {
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException(taskId);
        }
    }

    public Task resume(TaskId taskId) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException {
        try {
            TaskInfo taskInfo = taskManager.resume(taskId.getValue());
            return TaskFactory.getFactory().createTask(taskInfo);
        }
        catch (NoSuchTaskException e) {
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException(taskId);
        }
    }
}

