package org.gcube.data.analysis.tabulardata.service.impl.rules;

import static org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin.rule;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.RuleManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleColumnType;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchRuleException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.AppliedRulesResponse;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.RuleDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.rules.RuleId;
import org.gcube.data.analysis.tabulardata.service.rules.RuleInterface;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

public class RuleInterfaceImpl implements RuleInterface{

	private RuleManagerProxy manager = rule().build();

	@Override
	public RuleId saveColumnRule(String name, String description,
			Expression rule, RuleColumnType columnType) {
		return new RuleId(manager.saveColumnRule(name, description, rule, columnType));
	}

	@Override
	public List<RuleDescription> getRules() {
		return manager.getRules();
	}

	@Override
	public List<RuleDescription> getRulesByScope(RuleScope scope) {
		return manager.getRulesByScope(scope);
	}

	@Override
	public void removeRuleById(RuleId id) throws NoSuchRuleException {
		manager.remove(id.getValue());
	}

	@Override
	public void updateColumnRule(RuleId id, String name, String description,
			Expression rule, RuleColumnType columnType) throws NoSuchRuleException{
		manager.updateColumnRule(id.getValue(), name, description, rule, columnType);		
	}

	@Override
	public List<RuleDescription> getApplicableBaseColumnRules(
			Class<? extends DataType> dataTypeClass) {
		return manager.getApplicableBaseColumnRules(dataTypeClass);
	}

	@Override
	public Task applyColumnRule(TabularResourceId tabularResourceId, String columnId,
			List<RuleId> ruleIds) throws NoSuchRuleException,
			NoSuchTabularResourceException {
		ArrayList<Long> ruleIdsTranformed = new ArrayList<>(ruleIds.size());
		for (RuleId id: ruleIds) ruleIdsTranformed.add(id.getValue());
		
		TaskInfo taskInfo = manager.applyColumnRule(tabularResourceId.getValue(), columnId, ruleIdsTranformed);
		return TaskFactory.getFactory().createTask(taskInfo);
	}

	@Override
	public AppliedRulesResponse getAppliedRulesByTabularResourceId(TabularResourceId id)
			throws NoSuchTabularResourceException {
		return manager.getAppliedRulesByTabularResourceId(id.getValue());
	}

	@Override
	public RuleDescription share(RuleId ruleId, AuthorizationToken... tokens)
			throws NoSuchRuleException, SecurityException {
		try {
			if (tokens==null || tokens.length ==0) throw new RuntimeException("list of users is empty");
			return manager.share(ruleId.getValue(), tokens);
		} catch (InternalSecurityException e) {
			throw new SecurityException(e.getMessage());
		}
	}

	@Override
	public RuleDescription unshare(RuleId ruleId, AuthorizationToken... tokens)
			throws NoSuchRuleException, SecurityException {
		try {
			if (tokens==null || tokens.length ==0) throw new RuntimeException("list of users is empty");
			return manager.unshare(ruleId.getValue(), tokens);
		} catch (InternalSecurityException e) {
			throw new SecurityException(e.getMessage());
		}
	}

}
