/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.tabular;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.ExternalResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.HistoryManagerProxy;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TabularResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResourceType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.resources.ResourceDescriptor;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.service.impl.tabular.TabularResourceObject;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularResourceImpl
implements TabularResourceInterface {
    private static Logger logger = LoggerFactory.getLogger(TabularResourceImpl.class);
    private volatile HistoryManagerProxy historyManager = (HistoryManagerProxy)AbstractPlugin.history().build();
    private volatile TabularResourceManagerProxy tabularResourceProxy = (TabularResourceManagerProxy)AbstractPlugin.tabularResource().build();
    private volatile ExternalResourceManagerProxy externalResourceProxy = (ExternalResourceManagerProxy)AbstractPlugin.externalResource().build();

    public List<org.gcube.data.analysis.tabulardata.service.tabular.TabularResource> getTabularResources() {
        List remoteResources = this.tabularResourceProxy.getAllTabularResources();
        Iterator it = remoteResources.iterator();
        ArrayList<org.gcube.data.analysis.tabulardata.service.tabular.TabularResource> tabularResources = new ArrayList<org.gcube.data.analysis.tabulardata.service.tabular.TabularResource>(remoteResources.size());
        while (it.hasNext()) {
            tabularResources.add(new TabularResourceObject((TabularResource)it.next()));
        }
        return tabularResources;
    }

    public org.gcube.data.analysis.tabulardata.service.tabular.TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        return new TabularResourceObject(this.tabularResourceProxy.getTabularResource(id.getValue()));
    }

    public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        this.tabularResourceProxy.remove(id.getValue());
    }

    public org.gcube.data.analysis.tabulardata.service.tabular.TabularResource createTabularResource() {
        try {
            TabularResource tabularResource = this.tabularResourceProxy.createTabularResource(TabularResourceType.STANDARD);
            return new TabularResourceObject(tabularResource);
        }
        catch (Exception e) {
            logger.error("error creating tabule resource on the service", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public org.gcube.data.analysis.tabulardata.service.tabular.TabularResource createFlow() {
        try {
            TabularResource tabularResource = this.tabularResourceProxy.createTabularResource(TabularResourceType.FLOW);
            return new TabularResourceObject(tabularResource);
        }
        catch (Exception e) {
            logger.error("error creating tabule resource on the service", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Table getLastTable(TabularResourceId id) throws NoSuchTabularResourceException, NoSuchTableException {
        return this.historyManager.getLastTable(id.getValue());
    }

    public org.gcube.data.analysis.tabulardata.service.tabular.TabularResource share(TabularResourceId tabularResourceId, AuthorizationToken ... tokens) throws NoSuchTabularResourceException, SecurityException {
        try {
            if (tokens == null || tokens.length == 0) {
                throw new RuntimeException("list of users is empty");
            }
            return new TabularResourceObject((TabularResource)this.tabularResourceProxy.share((Object)tabularResourceId.getValue(), tokens));
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e.getMessage());
        }
    }

    public org.gcube.data.analysis.tabulardata.service.tabular.TabularResource unshare(TabularResourceId tabularResourceId, AuthorizationToken ... tokens) throws NoSuchTabularResourceException, SecurityException {
        try {
            if (tokens == null || tokens.length == 0) {
                throw new RuntimeException("list of users is empty");
            }
            return new TabularResourceObject((TabularResource)this.tabularResourceProxy.unshare((Object)tabularResourceId.getValue(), tokens));
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e.getMessage());
        }
    }

    public List<org.gcube.data.analysis.tabulardata.service.tabular.TabularResource> getTabularResourcesByType(String type) {
        List remoteResources = this.tabularResourceProxy.getTabularResourcesByType(type);
        Iterator it = remoteResources.iterator();
        ArrayList<org.gcube.data.analysis.tabulardata.service.tabular.TabularResource> tabularResources = new ArrayList<org.gcube.data.analysis.tabulardata.service.tabular.TabularResource>(remoteResources.size());
        while (it.hasNext()) {
            tabularResources.add(new TabularResourceObject((TabularResource)it.next()));
        }
        return tabularResources;
    }

    public List<ResourceDescriptor> getResources(TabularResourceId id) throws NoSuchTabularResourceException {
        return this.externalResourceProxy.getResourcePerTabularResource(id.getValue());
    }

    public List<ResourceDescriptor> getResourcesByType(TabularResourceId id, ResourceType type) throws NoSuchTabularResourceException {
        return this.externalResourceProxy.getResourcePerTabularResourceAndType(id.getValue(), type);
    }

    public ResourceDescriptor removeResurce(long resourceId) {
        return this.externalResourceProxy.removeResource(resourceId);
    }
}

