package org.gcube.data.analysis.tabulardata.service.tabular;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJobClassifier;

public class HistoryStepImpl implements HistoryStep {
	
	private OperationInvocation invocation;
	private Table resultTable;
	private TaskJobClassifier operationClassifier;

	public HistoryStepImpl(OperationInvocation invocation, Table resultTable, TaskJobClassifier operationClassifier) {
		this.invocation = invocation;
		this.resultTable = resultTable;
		this.operationClassifier = operationClassifier;
	}

	@Override
	public OperationInvocation getOperationInvocation() {
		return invocation;
	}

	@Override
	public Table getResultTable() {
		return resultTable;
	}

	@Override
	public TaskJobClassifier getOperationClassifier() {
		return operationClassifier;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((invocation == null) ? 0 : invocation.hashCode());
		result = prime * result + ((operationClassifier == null) ? 0 : operationClassifier.hashCode());
		result = prime * result + ((resultTable == null) ? 0 : resultTable.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		HistoryStepImpl other = (HistoryStepImpl) obj;
		if (invocation == null) {
			if (other.invocation != null)
				return false;
		} else if (!invocation.equals(other.invocation))
			return false;
		if (operationClassifier != other.operationClassifier)
			return false;
		if (resultTable == null) {
			if (other.resultTable != null)
				return false;
		} else if (!resultTable.equals(other.resultTable))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("HistoryStepImpl [invocation=");
		builder.append(invocation);
		builder.append(", resultTable=");
		builder.append(resultTable);
		builder.append(", operationClassifier=");
		builder.append(operationClassifier);
		builder.append("]");
		return builder.toString();
	}
	
	

}
