/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.tabular;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.ServiceState;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.analysis.tabulardata.service.tabular.ImmutableTabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;

public class TabularResourceInterfaceMock
implements TabularResourceInterface {
    public List<TabularResource> getTabularResources() {
        return ServiceState.tabularResources;
    }

    public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        for (TabularResource tabularResource : ServiceState.tabularResources) {
            if (!id.equals((Object)tabularResource.getId())) continue;
            return tabularResource;
        }
        throw new NoSuchTabularResourceException(id);
    }

    public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        TabularResource toRemove = this.getTabularResource(id);
        ServiceState.tabularResources.remove(toRemove);
    }

    public TabularResource cloneTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        TabularResource tabularResourceToClone = this.getTabularResource(id);
        ImmutableTabularResource newTabularResource = new ImmutableTabularResource(tabularResourceToClone);
        ServiceState.tabularResources.add(newTabularResource);
        return newTabularResource;
    }

    public TabularResource cloneTabularResource(TabularResourceId id, TableId lastTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        TabularResource tabularResourceToClone = this.getTabularResource(id);
        ArrayList newHistory = Lists.newArrayList();
        for (HistoryStep historyStep : newHistory) {
            if (historyStep.getResultTable().getId().equals((Object)lastTableId)) {
                newHistory.add(historyStep);
                ImmutableTabularResource result = new ImmutableTabularResource((List<HistoryStep>)newHistory, tabularResourceToClone.getAllMetadata());
                ServiceState.tabularResources.add(result);
                return result;
            }
            newHistory.add(historyStep);
        }
        throw new NoSuchTableException(lastTableId);
    }

    public TabularResource createTabularResource() {
        ImmutableTabularResource newTabularResource = new ImmutableTabularResource();
        ServiceState.tabularResources.add(newTabularResource);
        return newTabularResource;
    }
}

