/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.tabular;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.metadata.ArrayListMetadataHolder;
import org.gcube.data.analysis.tabulardata.metadata.Metadata;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;

public class ImmutableTabularResource
implements TabularResource {
    private static final long serialVersionUID = -57876758536246103L;
    private static long lastId = 0L;
    private TabularResourceId id;
    private List<HistoryStep> history = Lists.newArrayList();
    private ArrayListMetadataHolder<TabularResourceMetadata> metadataDelegate = new ArrayListMetadataHolder();

    public ImmutableTabularResource(TabularResource copy) {
        this.id = new TabularResourceId(lastId++);
        this.history = copy.getHistory();
        this.metadataDelegate.metadata = new ArrayList(copy.getAllMetadata());
    }

    public ImmutableTabularResource() {
        this.id = new TabularResourceId(lastId++);
    }

    public ImmutableTabularResource(List<HistoryStep> history, TabularResourceMetadata ... metadata) {
        this.id = new TabularResourceId(lastId++);
        this.history = history;
        this.metadataDelegate.metadata = Lists.newArrayList((Object[])metadata);
    }

    public ImmutableTabularResource(List<HistoryStep> history, Collection<TabularResourceMetadata> metadata) {
        this.id = new TabularResourceId(lastId++);
        this.history = history;
        this.metadataDelegate.metadata = Lists.newArrayList(metadata);
    }

    public TabularResourceId getId() {
        return this.id;
    }

    public List<HistoryStep> getHistory() {
        return this.history;
    }

    public <C extends TabularResourceMetadata> C getMetadata(Class<C> metadataType) throws NoSuchMetadataException {
        return (C)((TabularResourceMetadata)this.metadataDelegate.getMetadata(metadataType));
    }

    public void removeMetadata(Class<? extends TabularResourceMetadata> metadataType) {
        this.metadataDelegate.removeMetadata(metadataType);
    }

    public void setMetadata(TabularResourceMetadata metadata) {
        this.metadataDelegate.setMetadata((Metadata)metadata);
    }

    public Collection<TabularResourceMetadata> getAllMetadata() {
        return this.metadataDelegate.getAllMetadata();
    }

    public void setAllMetadata(Collection<TabularResourceMetadata> metadata) {
        this.metadataDelegate.setAllMetadata(metadata);
    }

    public void removeAllMetadata() {
        this.metadataDelegate.removeAllMetadata();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.history == null ? 0 : this.history.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.metadataDelegate == null ? 0 : this.metadataDelegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableTabularResource other = (ImmutableTabularResource)obj;
        if (this.history == null ? other.history != null : !this.history.equals(other.history)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals((Object)other.id)) {
            return false;
        }
        return !(this.metadataDelegate == null ? other.metadataDelegate != null : !this.metadataDelegate.equals(other.metadataDelegate));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TabularResourceImpl [id=");
        builder.append(this.id);
        builder.append(", history=");
        builder.append(this.history);
        builder.append(", metadata=");
        builder.append(this.getAllMetadata());
        builder.append("]");
        return builder.toString();
    }
}

