package org.gcube.data.td.commons.webservice;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;
import org.gcube.data.td.commons.utils.Constants;
import org.gcube.data.td.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.td.commons.webservice.types.TaskInfo;

@WebService(targetNamespace=Constants.TNS)
@SOAPBinding(style = Style.DOCUMENT, use=Use.LITERAL)
public interface TaskManager {

	public static final String SERVICE_NAME = "taskmanager";
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	TaskInfo remove(String identifier) throws NoSuchTaskException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	TaskInfo get(String identifier) throws NoSuchTaskException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	TaskInfo abort(String identifier) throws NoSuchTaskException;
		
}
