package org.gcube.data.analysis.tabulardata.commons.templates.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public abstract class TemplateAction<T> {

	public abstract T getIdentifier();	

	public abstract Map<String, Object> getParameters();

	public Map<String,Object> replaceColumnReferences(TableId tableId, Map<String, ColumnLocalId> columnMapping){
		Map<String,Object> parameters = getParameters();
		if (parameters==null || parameters.isEmpty())
			return parameters;
		Map<String, Object> returnMap = new HashMap<String, Object>();
		for (Entry<String, Object> entry: parameters.entrySet()){
			if (entry.getValue() instanceof ColumnReference){
				ColumnReference ref = (ColumnReference) entry.getValue();
				if (columnMapping.containsKey(ref.getColumnId().toString())){
					ColumnLocalId newId = columnMapping.get(ref.getColumnId().toString());
					ref.setColumnId(newId);
					ref.setTableId(tableId);
				}
			}
		}
		return returnMap;
	}
}
