package org.gcube.data.analysis.tabulardata.commons.webservice.types;

import java.util.Calendar;
import java.util.List;
import java.util.UUID;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.gcube.data.analysis.tabulardata.commons.webservice.types.adapters.ThrowableAdapter;


@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class TaskInfo{
	
	public enum TaskType{
		TEMPLATE,
		OPERATION
	}

	@XmlElement
	protected TaskType type = TaskType.OPERATION;
	
	@XmlElement
	protected long referenceId;
	
	@XmlElement
	private String identifier;

	@XmlElement
	private String submitter;
	
	@XmlElement
	private Calendar startTime;
	
	@XmlElement
	private Calendar endTime;
	
	
	@XmlJavaTypeAdapter(ThrowableAdapter.class)
	private Throwable errorCause;
	
	@XmlElement
	private List<TaskStep> taskSteps;
	
	@XmlElement
	private TaskStatus status;
	
	@XmlElement
	private WorkerResult result;
	
	TaskInfo(){}
	
	public TaskInfo(String submitter){
		this.submitter = submitter;
		this.identifier = UUID.randomUUID().toString();
	}
	
	/**
	 * @return the identifier
	 */
	public String getIdentifier() {
		return identifier;
	}

	public boolean isAborted(){
		return this.getStatus()== TaskStatus.ABORTED;
	}
		
	/**
	 * @return the startTime
	 */
	public Calendar getStartTime() {
		return startTime;
	}

	/**
	 * @return the endTime
	 */
	public Calendar getEndTime() {
		return endTime;
	}
	
	
	/**
	 * @param startTime the startTime to set
	 */
	public void setStartTime(Calendar startTime) {
		this.startTime = startTime;
	}

	/**
	 * @param endTime the endTime to set
	 */
	public void setEndTime(Calendar endTime) {
		this.endTime = endTime;
	}

	public Throwable getErrorCause() {
		return errorCause;
	}

	public void setErrorCause(Throwable errorCause) {
		this.errorCause = errorCause;
	}
	
	/**
	 * @return the taskSteps
	 */
	public List<TaskStep> getTaskSteps() {
		return taskSteps;
	}

	/**
	 * @param taskSteps the taskSteps to set
	 */
	public void setTaskSteps(List<TaskStep> taskSteps) {
		this.taskSteps = taskSteps;
	}

	
	/**
	 * @return the submitter
	 */
	public String getSubmitter() {
		return submitter;
	}

	/**
	 * @return the status
	 */
	public TaskStatus getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(TaskStatus status) {
		this.status = status;
	}
		
	/**
	 * @return the result
	 */
	public WorkerResult getResult() {
		return result;
	}
	
	/**
	 * @return the type
	 */
	public TaskType getType() {
		return type;
	}

	/**
	 * @param result the result to set
	 */
	public void setResult(WorkerResult result) {
		this.result = result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "TaskInfo [type="+type+" ,identifier=" + identifier + ", startTime="
				+ startTime + ", endTime=" + endTime 
				+ ", errorCause=" + errorCause + "]";
	}


	
}
