package org.gcube.data.analysis.tabulardata.commons.templates.model.columns;

import java.util.Arrays;
import java.util.List;

import org.gcube.data.analysis.tabulardata.commons.utils.DimensionReference;
import org.gcube.data.analysis.tabulardata.commons.utils.LocaleReference;
import org.gcube.data.analysis.tabulardata.commons.utils.TimeDimensionReference;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

@SuppressWarnings("unchecked")
public enum ColumnCategory {
		
	ATTRIBUTE(null, IntegerType.class, NumericType.class, TextType.class, DateType.class),
	DIMENSION(DimensionReference.class, IntegerType.class), 
	TIMEDIMENSION(TimeDimensionReference.class, IntegerType.class), 
	MEASURE(null, IntegerType.class, NumericType.class),
	CODENAME(LocaleReference.class,TextType.class),
	CODEDESCRIPTION(null, TextType.class),
	ANNOTATION(null, TextType.class),
	CODE(null, TextType.class);
	
	private List<Class<? extends DataType>> classes;
	
	private boolean referenceRequired;
	
	private Class<?> referenceClass;
	
	private ColumnCategory(Class<?> referenceClass, Class<? extends DataType> ... classes) {
		this.classes = Arrays.asList(classes);
		this.referenceRequired = referenceClass!=null;
		this.referenceClass = referenceClass;
	}

	/**
	 * @return the classes
	 */
	public List<Class<? extends DataType>> getAllowedClasses() {
		return classes;
	}

	/**
	 * @return the referenceRequired
	 */
	public boolean isReferenceRequired() {
		return referenceRequired;
	}

	public Class<?> getReferenceClass(){
		return referenceClass;
	}
}
