package org.gcube.data.analysis.tabulardata.commons.webservice;

import java.util.List;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;

import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleColumnType;
import org.gcube.data.analysis.tabulardata.commons.utils.Constants;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.RuleDescription;
import org.gcube.data.analysis.tabulardata.expression.Expression;

@WebService(targetNamespace=Constants.RULE_TNS)
@SOAPBinding(style = Style.DOCUMENT, use=Use.LITERAL)
public interface RuleManager {

	public static final String SERVICE_NAME = "rulemanager";

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	long saveColumnRule(String name, String description, Expression rule, RuleColumnType columnType ) throws InternalSecurityException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<RuleDescription> getRules() throws InternalSecurityException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<RuleDescription> getRulesByScope(RuleScope scope) throws InternalSecurityException;
	
}
