/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.columns;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.commons.templates.model.ReferenceObject;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Representable;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.utils.DimensionReference;
import org.gcube.data.analysis.tabulardata.commons.utils.FormatReference;
import org.gcube.data.analysis.tabulardata.commons.utils.LocaleReference;
import org.gcube.data.analysis.tabulardata.commons.utils.TimeDimensionReference;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TemplateColumn<T extends DataType>
implements Serializable,
Representable {
    private static final long serialVersionUID = 1L;
    private String id = UUID.randomUUID().toString();
    private ColumnCategory columnType;
    private String label;
    @XmlElementRefs(value={@XmlElementRef(type=DimensionReference.class), @XmlElementRef(type=TimeDimensionReference.class), @XmlElementRef(type=LocaleReference.class), @XmlElementRef(type=FormatReference.class)})
    private ReferenceObject reference;
    private List<Long> ruleIds = new ArrayList<Long>();
    private List<Expression> expressions = new ArrayList<Expression>();
    private Class<T> valueType;

    private TemplateColumn() {
    }

    public TemplateColumn(ColumnCategory columnType, Class<T> valueType) {
        if (!columnType.getAllowedClasses().contains(valueType)) {
            throw new IllegalArgumentException(String.format("valueType %s not allowed for column %s", new Object[]{valueType.getName(), columnType}));
        }
        if (columnType.isReferenceRequired()) {
            throw new IllegalArgumentException(String.format("a valid reference is required", new Object[0]));
        }
        this.columnType = columnType;
        this.valueType = valueType;
    }

    public TemplateColumn(ColumnCategory columnType, Class<T> valueType, ReferenceObject reference) {
        if (!columnType.getAllowedClasses().contains(valueType)) {
            throw new IllegalArgumentException(String.format("valueType %s not allowed for column %s", valueType.getName(), this.getClass().getSimpleName()));
        }
        if (!(columnType.isReferenceRequired() && reference != null && reference.getClass().equals(columnType.getReferenceClass()) && reference.check(valueType))) {
            throw new IllegalArgumentException(String.format("a valid reference is required", new Object[0]));
        }
        this.columnType = columnType;
        this.valueType = valueType;
        this.reference = reference;
    }

    public ColumnCategory getColumnType() {
        return this.columnType;
    }

    public Class<? extends DataType> getValueType() {
        return this.valueType;
    }

    public String getId() {
        return this.id;
    }

    public List<Long> getRules() {
        return Collections.unmodifiableList(this.ruleIds);
    }

    public void addRule(Long ruleId) {
        this.ruleIds.add(ruleId);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<Expression> getExpressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public void setId(String id) {
        this.id = id;
    }

    public ReferenceObject getReference() {
        return this.reference;
    }

    public String toString() {
        return "TemplateColumn [id=" + this.id + ", columnType=" + (Object)((Object)this.columnType) + ", rules=" + this.ruleIds + ", valueType=" + this.valueType.getName() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateColumn other = (TemplateColumn)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public String getRepresentation() {
        return String.valueOf(this.label) + " (" + (Object)((Object)this.columnType) + ")";
    }
}

