/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.gcube.data.analysis.tabulardata.commons.templates.model.ColumnDescriptor;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.AddColumnAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.ChangeToTimeDimensionAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.DeleteColumnAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.NormalizeTableAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.ReplaceByExpressionAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.TemplateActionColumnReference;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.TimeAggregationAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.PlaceholderReplacer;
import org.gcube.data.analysis.tabulardata.expression.leaf.ColumnReferencePlaceholder;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={AddColumnAction.class, ChangeToTimeDimensionAction.class, DeleteColumnAction.class, NormalizeTableAction.class, TimeAggregationAction.class, ReplaceByExpressionAction.class})
public abstract class TemplateAction<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String belongsToGroup = null;

    public abstract boolean usesExpression();

    public abstract T getIdentifier();

    public abstract List<TemplateColumn<?>> getPostOperationStructure(List<TemplateColumn<?>> var1);

    public abstract Map<String, Object> getParameters();

    protected TemplateAction() {
    }

    public Map<String, Object> replaceColumnReferences(TableId tableId, Map<String, ColumnDescriptor> columnMapping) throws Exception {
        Map<String, Object> parameters = this.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return parameters;
        }
        return this.getNewInstanceMap(tableId, columnMapping, this.getParameters());
    }

    private Map<String, Object> getNewInstanceMap(TableId tableId, Map<String, ColumnDescriptor> columnMapping, Map<String, Object> oldInstances) throws Exception {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : oldInstances.entrySet()) {
            returnMap.put(entry.getKey(), this.getNewObjectInstance(entry.getValue(), columnMapping, tableId));
        }
        return returnMap;
    }

    private Object getNewObjectInstance(Object value, Map<String, ColumnDescriptor> columnMapping, TableId tableId) throws Exception {
        if (value instanceof TemplateActionColumnReference) {
            String columnId = ((TemplateActionColumnReference)value).getColumnId();
            if (columnMapping.containsKey(columnId)) {
                ColumnLocalId newId = columnMapping.get(columnId).getColumnId();
                ColumnReference colRef = new ColumnReference(tableId, newId);
                return colRef;
            }
            throw new RuntimeException("unexpected error, id " + columnId + " not found in column mapping");
        }
        if (value instanceof ColumnReference) {
            ColumnReference ref = (ColumnReference)value;
            if (columnMapping.containsKey(ref.getColumnId().toString())) {
                ColumnLocalId newId = columnMapping.get(ref.getColumnId().toString()).getColumnId();
                ref.setColumnId(newId);
                return ref;
            }
        } else if (value instanceof String) {
            if (columnMapping.containsKey((String)value)) {
                return columnMapping.get((String)value).getColumnId().getValue();
            }
        } else {
            PlaceholderReplacer pr;
            if (value instanceof Map) {
                Map compParam = (Map)value;
                return this.getNewInstanceMap(tableId, columnMapping, compParam);
            }
            if (value instanceof List) {
                List compParam = (List)value;
                ArrayList<Object> newInstances = new ArrayList<Object>();
                for (Object param : compParam) {
                    newInstances.add(this.getNewObjectInstance(param, columnMapping, tableId));
                }
                return newInstances;
            }
            if (value instanceof ColumnReferencePlaceholder) {
                ColumnReferencePlaceholder pr2 = (ColumnReferencePlaceholder)value;
                return new ColumnReference(tableId, columnMapping.get(pr2.getId()).getColumnId(), columnMapping.get(pr2.getId()).getType());
            }
            if (value instanceof Expression && (pr = new PlaceholderReplacer((Expression)value)).hasPlaceholder()) {
                for (Map.Entry<String, ColumnDescriptor> mappingEntry : columnMapping.entrySet()) {
                    pr.replaceById(new ColumnReference(tableId, mappingEntry.getValue().getColumnId(), mappingEntry.getValue().getType()), mappingEntry.getKey());
                }
                return pr.getExpression();
            }
        }
        return value;
    }

    public void setBelogsToGroup(String groupId) {
        this.belongsToGroup = groupId;
    }

    public String getBelongsToGroup() {
        return this.belongsToGroup;
    }
}

