/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ArgumentDescriptor;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ContainerInstance;

public class ArgumentContainer {
    private String identifier = UUID.randomUUID().toString();
    private List<ArgumentDescriptor<?>> arguments;
    private List<ArgumentContainer> containers;
    private String name;
    private String description;
    private int minInstances;
    private int maxInstances;
    private ArgumentContainer parent;

    public ArgumentContainer(@NonNull List<ArgumentDescriptor<?>> arguments, @NonNull List<ArgumentContainer> containers, int minInstances, int maxInstances) {
        if (arguments == null) {
            throw new NullPointerException("arguments");
        }
        if (containers == null) {
            throw new NullPointerException("containers");
        }
        this.arguments = arguments;
        this.containers = containers;
        for (ArgumentContainer container : containers) {
            container.setParent(this);
        }
        this.minInstances = minInstances;
        this.maxInstances = maxInstances;
    }

    public Set<ArgumentDescriptor<?>> getFlattenedArguments() {
        HashSet toReturn = new HashSet();
        toReturn.addAll(this.arguments);
        for (ArgumentContainer container : this.containers) {
            toReturn.addAll(container.getFlattenedArguments());
        }
        return toReturn;
    }

    protected ContainerInstance createinstance(ContainerInstance parentInstance) {
        ContainerInstance instance = new ContainerInstance(this, parentInstance);
        return instance;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    private void setParent(ArgumentContainer parent) {
        this.parent = parent;
    }

    public ArgumentContainer getParent() {
        return this.parent;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<ArgumentDescriptor<?>> getArguments() {
        return this.arguments;
    }

    public List<ArgumentContainer> getContainers() {
        return this.containers;
    }

    public int getMinInstances() {
        return this.minInstances;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgumentContainer)) {
            return false;
        }
        ArgumentContainer other = (ArgumentContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArgumentContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 0 : $identifier.hashCode());
        return result;
    }
}

