/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.utils;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Version
implements Comparable<Version> {
    private int maior;
    private int minor;
    private int revision;
    private int age;

    private Version() {
    }

    public Version(int maior, int minor, int revision, int age) {
        this.maior = maior;
        this.minor = minor;
        this.revision = revision;
        this.age = age;
    }

    public String toString() {
        return String.valueOf(this.maior) + "." + this.minor + "." + this.revision + "-" + this.age;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maior;
        result = 31 * result + this.minor;
        result = 31 * result + this.revision;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.maior != other.maior) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.revision == other.revision;
    }

    @Override
    public int compareTo(Version o) {
        if (this.maior > o.maior) {
            return 1;
        }
        if (this.maior < o.maior) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        if (this.revision > o.revision) {
            return 1;
        }
        if (this.revision < o.revision) {
            return -1;
        }
        return 0;
    }

    public static Version parse(String version) {
        try {
            String[] ageSplit = version.split("-");
            int age = Integer.parseInt(ageSplit[1]);
            String[] mmrSplit = ageSplit[0].split("\\.");
            int maior = Integer.parseInt(mmrSplit[0]);
            int minor = Integer.parseInt(mmrSplit[1]);
            int revision = Integer.parseInt(mmrSplit[2]);
            return new Version(maior, minor, revision, age);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(String.valueOf(version) + " is not a valid TDM version");
        }
    }
}

