/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.metadata.resources;

import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.resources.Resource;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;

@NamedQueries(value={@NamedQuery(name="RES.getById", query="SELECT DISTINCT sr FROM StorableResource sr LEFT JOIN sr.tabularResource str WHERE  str.id = :id ORDER BY sr.creationDate DESC"), @NamedQuery(name="RES.getByType", query="SELECT DISTINCT sr FROM StorableResource sr LEFT JOIN sr.tabularResource str WHERE  str.id = :id AND sr.type = :type ORDER BY sr.creationDate DESC")})
@Entity
public class StorableResource {
    @Column
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected long id;
    @Column
    private String description;
    @Column
    private String name;
    @Column
    private ResourceType type;
    @Column
    private Resource resource;
    @Column
    private long creatorId;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar creationDate = Calendar.getInstance();
    @Column
    private String columnId = null;
    @ManyToOne
    private StorableTabularResource tabularResource;

    public StorableResource(String name, String description, ResourceType type, long creatorId, Resource resource) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.resource = resource;
        this.creatorId = creatorId;
    }

    public StorableResource(String name, String description, ResourceType type, long creatorId, String columnId, Resource resource) {
        this(name, description, type, creatorId, resource);
        this.columnId = columnId;
    }

    protected StorableResource() {
    }

    public StorableTabularResource getTabularResource() {
        return this.tabularResource;
    }

    public void setTabularResource(StorableTabularResource tabularResource) {
        this.tabularResource = tabularResource;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public String getDescription() {
        return this.description;
    }

    public ResourceType getType() {
        return this.type;
    }

    public Resource getResource() {
        return this.resource;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnId == null ? 0 : this.columnId.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorableResource other = (StorableResource)obj;
        if (this.columnId == null ? other.columnId != null : !this.columnId.equals(other.columnId)) {
            return false;
        }
        return this.id == other.id;
    }

    public String toString() {
        return "StorableResource [id=" + this.id + ", description=" + this.description + ", type=" + this.type + ", resource=" + this.resource.getStringValue() + ", creatorId=" + this.creatorId + ", creationDate=" + this.creationDate + ", columnId=" + this.columnId + ", tabularResource=" + this.tabularResource + "]";
    }
}

