/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.rules;

import java.util.List;
import javax.persistence.EntityManager;
import org.gcube.data.analysis.tabulardata.metadata.StorableRule;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.RuleMapping;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.task.RunnableTask;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRuleFinalAction
implements RunnableTask {
    private static final Logger log = LoggerFactory.getLogger(AddRuleFinalAction.class);
    long trId;
    private EntityManagerHelper emHelper;
    List<RuleMapping> ruleMappings;

    protected AddRuleFinalAction(long trId, List<RuleMapping> ruleMappings, EntityManagerHelper emHelper) {
        this.trId = trId;
        this.emHelper = emHelper;
        this.ruleMappings = ruleMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Table table) {
        try (EntityManager em = this.emHelper.getEntityManager();){
            em.getTransaction().begin();
            StorableTabularResource str = (StorableTabularResource)em.find(StorableTabularResource.class, (Object)this.trId);
            for (RuleMapping mapping : this.ruleMappings) {
                StorableRule rule = mapping.getStorableRule();
                rule.getRuleMappings().add(mapping);
                em.persist((Object)mapping);
                em.merge((Object)rule);
            }
            str.addRules(this.ruleMappings);
            em.merge((Object)str);
            em.getTransaction().commit();
        }
    }
}

