/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.gcube.data.analysis.tabulardata.commons.webservice.ExternalResourceManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.resources.ResourceDescriptor;
import org.gcube.data.analysis.tabulardata.metadata.resources.StorableResource;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.remover.ResourceRemoverProvider;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.gcube.data.analysis.tabulardata.utils.Factories;
import org.gcube.data.analysis.tabulardata.utils.Util;
import org.gcube.data.analysis.tabulardata.weld.WeldService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="ExternalResourceManagerPort", serviceName="externalresourcemanager", targetNamespace="http://gcube-system.org/externalresource", endpointInterface="org.gcube.data.analysis.tabulardata.commons.webservice.ExternalResourceManager")
@Singleton
@WeldService
public class ExternalResourceManagerImpl
implements ExternalResourceManager {
    private Logger logger = LoggerFactory.getLogger(ExternalResourceManagerImpl.class);
    @Inject
    private Factories factories;
    @Inject
    EntityManagerHelper emHelper;

    public List<ResourceDescriptor> getResourcePerTabularResource(long tabularResourceId) throws NoSuchTabularResourceException, InternalSecurityException {
        List descriptors = this.emHelper.getResults("RES.getById", StorableResource.class, Collections.singletonMap("id", tabularResourceId));
        this.logger.trace("requesting resources for id {} and returning {} elements ", (Object)tabularResourceId, (Object)descriptors.size());
        return Util.toResourceDescriptorList((List)descriptors);
    }

    public List<ResourceDescriptor> getResourcePerTabularResourceAndType(long tabularResourceId, ResourceType type) throws NoSuchTabularResourceException, InternalSecurityException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("id", tabularResourceId);
        parameters.put("type", type.name());
        List descriptors = this.emHelper.getResults("RES.getByType", StorableResource.class, parameters);
        this.logger.trace("requesting resources for id {} with type {} and returning {} elements ", new Object[]{tabularResourceId, type, descriptors.size()});
        return Util.toResourceDescriptorList((List)descriptors);
    }

    public ResourceDescriptor removeResource(long resourceId) throws InternalSecurityException {
        this.logger.trace("requesting remove resource for id {}", (Object)resourceId);
        EntityManager em = this.emHelper.getEntityManager();
        StorableResource sr = (StorableResource)em.find(StorableResource.class, (Object)resourceId);
        if (sr == null) {
            throw new InternalSecurityException("Storable resource not found");
        }
        ResourceDescriptor descriptor = Util.toResourceDescriptor((StorableResource)sr);
        WorkerFactory factory = this.factories.get(new OperationId(sr.getCreatorId()));
        if (factory != null && factory instanceof ResourceRemoverProvider) {
            try {
                ((ResourceRemoverProvider)factory).getResourceRemover().onRemove(sr.getResource());
                this.logger.info("resource with id {} removed", (Object)sr.getId());
            }
            catch (Exception e) {
                this.logger.warn("error remotely removing resource with id {} created by {} ", (Object)sr.getId(), (Object)factory.getOperationDescriptor().getName());
            }
        }
        sr.getTabularResource().removeResource(sr);
        try {
            em.getTransaction().begin();
            em.merge((Object)sr.getTabularResource());
            em.remove((Object)sr);
            em.getTransaction().commit();
        }
        catch (RollbackException re) {
            this.logger.error("error on transaction code", (Throwable)re);
            em.clear();
            throw re;
        }
        catch (DatabaseException de) {
            this.logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
            em.getTransaction().rollback();
            throw de;
        }
        catch (RuntimeException e) {
            this.logger.error("error on transaction code", (Throwable)e);
            em.getTransaction().rollback();
            em.clear();
            throw e;
        }
        this.logger.trace("resource with id {} removed", (Object)resourceId);
        return descriptor;
    }
}

