/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.persistence.EntityManager;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.data.analysis.tabulardata.commons.webservice.OperationManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.ExecutionFailedException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.HistoryNotFoundException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.BatchExecuteRequest;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.BatchOption;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.ExecuteRequest;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResourceType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.exceptions.NoSuchObjectException;
import org.gcube.data.analysis.tabulardata.exceptions.TabularResourceLockedException;
import org.gcube.data.analysis.tabulardata.metadata.StorableHistoryStep;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.invocation.InvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.MetadataWorker;
import org.gcube.data.analysis.tabulardata.task.RunnableTask;
import org.gcube.data.analysis.tabulardata.task.TaskContext;
import org.gcube.data.analysis.tabulardata.task.engine.TaskEngine;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.gcube.data.analysis.tabulardata.utils.Factories;
import org.gcube.data.analysis.tabulardata.utils.InternalInvocation;
import org.gcube.data.analysis.tabulardata.utils.OperationUtil;
import org.gcube.data.analysis.tabulardata.utils.Util;
import org.gcube.data.analysis.tabulardata.weld.WeldService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="OperationManagerPort", serviceName="operationmanager", targetNamespace="http://gcube-system.org/operation", endpointInterface="org.gcube.data.analysis.tabulardata.commons.webservice.OperationManager")
@Singleton
@WeldService
public class OperationManagerImpl
implements OperationManager {
    private static final long CLONE_OPERATION_ID = 102L;
    private Logger logger = LoggerFactory.getLogger(OperationManagerImpl.class);
    @Inject
    private CubeManager cubeManager;
    @Inject
    private Factories factories;
    @Inject
    private EntityManagerHelper emHelper;
    @Inject
    private OperationUtil opUtil;
    @Inject
    private TaskEngine taskEngine;

    @PostConstruct
    void initService() {
        this.logger.info("executing POST CONSTRUCT");
        Handler.activateProtocol();
    }

    public List<OperationDefinition> getCapabilities() {
        this.logger.info("calling getCapabilities in scope {}", (Object)ScopeProvider.instance.get());
        ArrayList<OperationDefinition> definitions = new ArrayList<OperationDefinition>();
        for (WorkerFactory factory : this.factories.values()) {
            OperationDescriptor descr = factory.getOperationDescriptor();
            definitions.add(new OperationDefinition(descr.getOperationId().getValue(), descr.getName(), descr.getDescription(), descr.getParameters()));
        }
        return definitions;
    }

    public OperationDefinition getOperationDescriptor(long operationId) throws OperationNotFoundException {
        this.logger.info("calling getCapabilities in scope {}", (Object)ScopeProvider.instance.get());
        if (!this.factories.containsKey(new OperationId(operationId))) {
            throw new OperationNotFoundException("operation with id " + operationId + "not found");
        }
        OperationDescriptor descr = this.factories.get(new OperationId(operationId)).getOperationDescriptor();
        return new OperationDefinition(descr.getOperationId().getValue(), descr.getName(), descr.getDescription(), descr.getParameters());
    }

    public TaskInfo execute(ExecuteRequest request) throws NoSuchTabularResourceException, OperationNotFoundException, InternalSecurityException {
        StorableTabularResource tabularResource;
        this.logger.info("calling execute invocations {} on TR wit id {}", (Object)request.getInvocation(), (Object)request.getTargetTabularResourceId());
        EntityManager entityManager = this.emHelper.getEntityManager();
        try {
            tabularResource = (StorableTabularResource)Util.getUserAuthorizedObject((Object)request.getTargetTabularResourceId(), StorableTabularResource.class, (EntityManager)entityManager);
        }
        catch (NoSuchObjectException e) {
            entityManager.close();
            throw new NoSuchTabularResourceException(request.getTargetTabularResourceId());
        }
        try {
            TaskInfo e = this.execute(Collections.singletonList(request.getInvocation()), BatchOption.NONE, tabularResource, false, entityManager);
            return e;
        }
        catch (TabularResourceLockedException ise) {
            this.logger.error("illegal state executing operation ", (Throwable)ise);
            throw new InternalSecurityException(ise.getCause());
        }
        finally {
            entityManager.close();
        }
    }

    public TaskInfo removeValidations(Long tabularResourceId) throws NoSuchTabularResourceException, InternalSecurityException {
        StorableTabularResource tabularResource;
        this.logger.info("calling remove validations on TR wit id {}", (Object)tabularResourceId);
        EntityManager entityManager = this.emHelper.getEntityManager();
        try {
            tabularResource = (StorableTabularResource)Util.getUserAuthorizedObject((Object)tabularResourceId, StorableTabularResource.class, (EntityManager)entityManager);
        }
        catch (NoSuchObjectException e) {
            entityManager.close();
            throw new NoSuchTabularResourceException(tabularResourceId.longValue());
        }
        try {
            TaskInfo e = this.execute(new ArrayList(0), BatchOption.NONE, tabularResource, true, entityManager);
            return e;
        }
        catch (OperationNotFoundException | TabularResourceLockedException ise) {
            this.logger.error("illegal state executing operation ", ise);
            throw new InternalSecurityException(ise.getCause());
        }
        finally {
            entityManager.close();
        }
    }

    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public TaskInfo batchExecute(BatchExecuteRequest request) throws NoSuchTabularResourceException, OperationNotFoundException, InternalSecurityException {
        StorableTabularResource tabularResource;
        EntityManager entityManager = this.emHelper.getEntityManager();
        this.logger.info("calling batch execute invocations {} on TR wit id {}", (Object)request.getInvocations(), (Object)request.getTargetTabularResourceId());
        try {
            tabularResource = (StorableTabularResource)Util.getUserAuthorizedObject((Object)request.getTargetTabularResourceId(), StorableTabularResource.class, (EntityManager)entityManager);
        }
        catch (NoSuchObjectException e) {
            entityManager.close();
            throw new NoSuchTabularResourceException(request.getTargetTabularResourceId());
        }
        try {
            TaskInfo e = this.execute(request.getInvocations(), request.getOption(), tabularResource, false, entityManager);
            return e;
        }
        catch (TabularResourceLockedException ise) {
            this.logger.error("illegal state executing operation ", (Throwable)ise);
            throw new InternalSecurityException(ise.getCause());
        }
        finally {
            entityManager.close();
        }
    }

    public TaskInfo execute(List<OperationExecution> invocations, BatchOption option, StorableTabularResource tabularResource, boolean internal, EntityManager entityManager) throws OperationNotFoundException, InternalSecurityException {
        return this.execute(invocations, option, tabularResource, internal, entityManager, null);
    }

    public TaskInfo execute(List<OperationExecution> invocations, BatchOption option, StorableTabularResource tabularResource, boolean internal, EntityManager entityManager, RunnableTask onSuccess) throws OperationNotFoundException, InternalSecurityException {
        this.logger.debug("tabular resource " + tabularResource.getId() + " is locked? " + tabularResource.isLocked());
        if (!(internal || tabularResource.getTabularResourceType() != TabularResourceType.FLOW || invocations.size() == 1 && invocations.get(0).getOperationId() == 102L)) {
            throw new InternalSecurityException("the operation cannot be executed on FLOWs");
        }
        long start = System.currentTimeMillis();
        ArrayList<InternalInvocation> invocationCouples = new ArrayList<InternalInvocation>(invocations.size());
        for (OperationExecution invocation : invocations) {
            InternalInvocation invocationCouple = this.opUtil.getInvocationById(invocation.getOperationId(), invocation.getParameters());
            if (invocation.getColumnId() != null) {
                invocationCouple.setColumnId(new ColumnLocalId(invocation.getColumnId()));
            }
            invocationCouples.add(invocationCouple);
        }
        TaskContext context = new TaskContext(invocationCouples, OnRowErrorAction.ASK);
        this.opUtil.addPostValidations(context, tabularResource);
        this.opUtil.addPostOperations(context);
        if (tabularResource.isFinalized() && !context.isParallelizableExecution()) {
            throw new RuntimeException("cannot execute data operation on finalized tabular resource");
        }
        String caller = AuthorizationProvider.instance.get().getClient().getId();
        TaskInfo toReturn = this.taskEngine.createTask(caller, context, tabularResource, onSuccess);
        this.logger.trace("execute took " + (System.currentTimeMillis() - start));
        return toReturn;
    }

    public TaskInfo rollbackTo(long tabularRessourceId, long historyStepId) throws HistoryNotFoundException, NoSuchTabularResourceException, OperationNotFoundException, InternalSecurityException {
        StorableHistoryStep sThs;
        StorableTabularResource sTr;
        EntityManager entityManager = this.emHelper.getEntityManager();
        try {
            sTr = (StorableTabularResource)Util.getUserAuthorizedObject((Object)tabularRessourceId, StorableTabularResource.class, (EntityManager)entityManager);
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTabularResourceException(tabularRessourceId);
        }
        if (sTr.isFinalized()) {
            throw new RuntimeException("cannot execute operation on finalized tabular resource");
        }
        try {
            sThs = (StorableHistoryStep)entityManager.find(StorableHistoryStep.class, (Object)historyStepId);
        }
        catch (Exception e) {
            throw new HistoryNotFoundException((Throwable)e);
        }
        if (!sTr.getHistorySteps().contains(sThs)) {
            throw new HistoryNotFoundException("history with id " + historyStepId + "not found");
        }
        int indexOfHistoryStep = sTr.getHistorySteps().indexOf(sThs);
        List historyStepIdToremoveOnRollback = this.getHistoryStepToRemoveOnRollback(sTr.getHistorySteps(), indexOfHistoryStep);
        TaskContext context = new TaskContext(this.getRollbackInvocations(sTr.getHistorySteps(), indexOfHistoryStep), OnRowErrorAction.ASK);
        if (!context.isParallelizableExecution()) {
            this.opUtil.addPostValidations(context, sTr);
            this.opUtil.addPostOperations(context);
        }
        String submitter = AuthorizationProvider.instance.get().getClient().getId();
        TaskInfo toReturn = this.taskEngine.createRollbackTask(submitter, context, sTr, historyStepIdToremoveOnRollback);
        entityManager.close();
        return toReturn;
    }

    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void executeSynchMetadataOperation(ExecuteRequest request) throws NoSuchTabularResourceException, OperationNotFoundException, InternalSecurityException, ExecutionFailedException {
        Worker worker;
        StorableTabularResource sTr;
        this.logger.info("executing synch operation {} on tabular resource {}", (Object)request.getInvocation(), (Object)request.getTargetTabularResourceId());
        EntityManager entityManager = this.emHelper.getEntityManager();
        try {
            sTr = (StorableTabularResource)Util.getUserAuthorizedObject((Object)request.getTargetTabularResourceId(), StorableTabularResource.class, (EntityManager)entityManager);
        }
        catch (NoSuchObjectException e) {
            this.logger.error("no such tabular resource ", (Throwable)e);
            throw new NoSuchTabularResourceException(request.getTargetTabularResourceId());
        }
        OperationId opId = new OperationId(request.getInvocation().getOperationId());
        if (!this.factories.containsKey(opId)) {
            this.logger.error("operation with id {} not found ", (Object)opId);
            throw new OperationNotFoundException("operation with id " + opId + " not found");
        }
        WorkerFactory factory = this.factories.get(opId);
        if (factory.getWorkerType() != MetadataWorker.class) {
            this.logger.error("invalid worker type ");
            throw new OperationNotFoundException("the operation with id " + opId + " is not a Metadata operation");
        }
        TableId table = new TableId(sTr.getTableId().longValue());
        InvocationCreator creator = InvocationCreator.getCreator((OperationDescriptor)factory.getOperationDescriptor()).setTargetTable(table);
        if (request.getInvocation().getColumnId() != null) {
            creator.setTargetColumn(new ColumnLocalId(request.getInvocation().getColumnId()));
        }
        creator.setParameters(request.getInvocation().getParameters());
        try {
            worker = factory.createWorker(creator.create());
            worker.run();
        }
        catch (InvalidInvocationException e) {
            this.logger.error("error executing synch operation ", (Throwable)e);
            throw new ExecutionFailedException("invalid invocation for metadata operation " + opId + " (" + e.getMessage() + ")");
        }
        catch (Exception e) {
            this.logger.error("error executing synch operation ", (Throwable)e);
            throw new ExecutionFailedException("unexpected exception for metadata operation " + opId);
        }
        if (worker.getStatus() == WorkerStatus.FAILED) {
            this.logger.error("error executing synch operation ", (Throwable)worker.getException());
            throw new ExecutionFailedException("error executing metadata worker (" + worker.getException().getMessage() + ")");
        }
    }

    private List<InternalInvocation> getRollbackInvocations(List<StorableHistoryStep> historySteps, int indexOfHistoryStep) throws HistoryNotFoundException, OperationNotFoundException {
        ArrayList<Object> invocationCouples = new ArrayList<InternalInvocation>();
        for (int i = historySteps.size() - 1; i > indexOfHistoryStep; --i) {
            StorableHistoryStep step = historySteps.get(i);
            if (step.isContainsDiff()) {
                WorkerFactory factory = this.factories.get(new OperationId(step.getOperationInvocation().getOperationId()));
                if (factory == null) {
                    this.logger.error("operation with id {} not found", (Object)step.getOperationInvocation().getOperationId());
                    throw new OperationNotFoundException("operation with id " + step.getOperationInvocation().getOperationId() + " not found");
                }
                try {
                    InternalInvocation invocationCouple = new InternalInvocation(step.getOperationInvocation().getParameters(), factory, this.cubeManager.getTable(new TableId(step.getTableId().longValue())));
                    if (step.getOperationInvocation().getColumnId() != null) {
                        invocationCouple.setColumnId(new ColumnLocalId(step.getOperationInvocation().getColumnId()));
                    }
                    invocationCouples.add(invocationCouple);
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn("error retrieving history step for rollbackable operation", (Throwable)e);
                    throw new HistoryNotFoundException((Throwable)e);
                }
            }
            try {
                invocationCouples = new ArrayList();
                invocationCouples.add((InternalInvocation)new InternalInvocation.NOPInvocation(this.cubeManager.getTable(new TableId(step.getTableId().longValue()))));
                continue;
            }
            catch (Exception e) {
                this.logger.warn("error retrieving history step for not rollbackable operation", (Throwable)e);
                throw new HistoryNotFoundException((Throwable)e);
            }
        }
        return invocationCouples;
    }

    private List<Long> getHistoryStepToRemoveOnRollback(List<StorableHistoryStep> historySteps, int indexOfHistoryStep) {
        ArrayList<Long> historyStepToRemove = new ArrayList<Long>();
        for (int i = historySteps.size() - 1; i > indexOfHistoryStep; --i) {
            StorableHistoryStep step = historySteps.get(i);
            historyStepToRemove.add(step.getId());
        }
        return historyStepToRemove;
    }
}

