/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import javax.persistence.EntityManager;
import org.gcube.data.analysis.tabulardata.commons.utils.SharingEntity;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.exceptions.NoSuchObjectException;
import org.gcube.data.analysis.tabulardata.metadata.Identifiable;
import org.gcube.data.analysis.tabulardata.utils.Util;

public class SharingHelper {
    public static <T, I extends Identifiable> I share(Class<I> returnClass, T entityId, EntityManager entityManager, SharingEntity ... entities) throws NoSuchObjectException, InternalSecurityException {
        Identifiable sTr = Util.getOwnerhipAuthorizedObject(entityId, returnClass, (EntityManager)entityManager);
        if (entities != null && entities.length > 0) {
            for (SharingEntity entity : entities) {
                if (entity.getType() == SharingEntity.Type.USER) {
                    String userToken = String.format("u(%s)", entity.getIdentifier());
                    if (sTr.getSharedWith().contains(userToken)) continue;
                    sTr.getSharedWith().add(userToken);
                    continue;
                }
                String groupToken = String.format("g(%s)", entity.getIdentifier());
                if (sTr.getSharedWith().contains(groupToken)) continue;
                sTr.getSharedWith().add(groupToken);
            }
            entityManager.getTransaction().begin();
            entityManager.merge((Object)sTr);
            entityManager.getTransaction().commit();
        }
        return (I)sTr;
    }

    public static <T, I extends Identifiable> I unshare(Class<I> returnClass, T entityId, EntityManager entityManager, SharingEntity ... entities) throws NoSuchObjectException, InternalSecurityException {
        Identifiable sTr = Util.getOwnerhipAuthorizedObject(entityId, returnClass, (EntityManager)entityManager);
        if (entities != null && entities.length > 0) {
            for (SharingEntity entity : entities) {
                if (entity.getType() == SharingEntity.Type.USER) {
                    sTr.getSharedWith().remove(String.format("u(%s)", entity.getIdentifier()));
                    continue;
                }
                sTr.getSharedWith().remove(String.format("g(%s)", entity.getIdentifier()));
            }
            entityManager.getTransaction().begin();
            entityManager.merge((Object)sTr);
            entityManager.getTransaction().commit();
        }
        return (I)sTr;
    }
}

