/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.commons.templates.model.ColumnDescriptor;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.ColumnCreatorAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.TemplateColumnAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.utils.DimensionReference;
import org.gcube.data.analysis.tabulardata.commons.utils.FormatReference;
import org.gcube.data.analysis.tabulardata.commons.utils.LocaleReference;
import org.gcube.data.analysis.tabulardata.commons.utils.TimeDimensionReference;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.TemplateNotCompatibleException;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.PlaceholderReplacer;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.templates.TemplateEngine;
import org.gcube.data.analysis.tabulardata.templates.TemplateFinalActionExecutor;
import org.gcube.data.analysis.tabulardata.templates.TemplateFinalActionFactory;
import org.gcube.data.analysis.tabulardata.utils.Factories;
import org.gcube.data.analysis.tabulardata.utils.InternalInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(TemplateEngine.class);
    private static final OperationId changeTableTypeOperationID = new OperationId(1002L);
    private static final OperationId changeToAttributeColumnTypeOperationID = new OperationId(2001L);
    private static final OperationId changeToMeasureColumnTypeOperationID = new OperationId(2002L);
    private static final OperationId changeToCodeNameColumnTypeOperationID = new OperationId(2004L);
    private static final OperationId changeToCodeDescriptionColumnTypeOperationID = new OperationId(2005L);
    private static final OperationId changeToAnnotationColumnTypeOperationID = new OperationId(2000L);
    private static final OperationId changeToCodeColumnTypeOperationID = new OperationId(2003L);
    private static final OperationId changeToDimensionColumnTypeOperationID = new OperationId(2006L);
    private static final OperationId changeToTimeDimensionColumnTypeOperationID = new OperationId(2007L);
    private static final String TABLE_TYPE_PARAMETER_ID = "tableType";
    private static final String TARGET_DATA_TYPE_PARAMETER_ID = "targetDataType";
    private static final String PERIOD_FORMAT_PARAMETER_ID = "periodFormat";
    private static final String INPUT_FORMAT_ID = "inputFormatId";
    private static final String TARGET_COLUMN_PARAMETER = "refColumn";
    private Factories operationFactories;
    private Template template;
    private Table table;
    private TemplateFinalActionFactory tfaf;

    protected TemplateEngine(Template template, Table table, Factories operationFactories, TemplateFinalActionFactory tfaf) {
        this.operationFactories = operationFactories;
        this.template = template;
        this.table = table;
        this.tfaf = tfaf;
    }

    private InternalInvocation getRuleInvocation() throws Exception {
        String EXPRESSION_PARAMETER = "expression";
        String COMPOSITE_RULE_PARAMETER = "rules";
        String NAME_PARAMETER = "name";
        long RULE_VALIDATION_OP = 5009L;
        WorkerFactory factory = this.operationFactories.get(new OperationId(5009L));
        if (factory == null) {
            log.error("operation with id {} not found", (Object)5009L);
            throw new OperationNotFoundException("operation with id 5009 not found");
        }
        Map mapTemplateColumnToTable = this.getColumnMappingTemplateToTable(this.table);
        ArrayList rulesParameterInstance = new ArrayList();
        for (TemplateColumn templateColumn : this.template.getColumns()) {
            String columnId = ((ColumnDescriptor)mapTemplateColumnToTable.get(templateColumn.getId())).getColumnId().getValue();
            DataType columnType = (DataType)((ColumnDescriptor)mapTemplateColumnToTable.get(templateColumn.getId())).getType().newInstance();
            HashMap<String, String> placeholderColumnMapping = new HashMap<String, String>(1);
            placeholderColumnMapping.put(templateColumn.getId(), columnId);
            for (Expression expression : templateColumn.getExpressions()) {
                PlaceholderReplacer replacer = new PlaceholderReplacer(expression).replaceAll(new ColumnReference(this.table.getId(), new ColumnLocalId(columnId), columnType));
                HashMap<String, Object> singleRuleparameters = new HashMap<String, Object>();
                singleRuleparameters.put("expression", replacer.getExpression());
                singleRuleparameters.put("name", "anonymus rule");
                rulesParameterInstance.add(singleRuleparameters);
            }
        }
        if (rulesParameterInstance.isEmpty()) {
            throw new Exception("no rules found");
        }
        InternalInvocation internalInvocation = new InternalInvocation(Collections.singletonMap("rules", rulesParameterInstance), factory);
        return internalInvocation;
    }

    public List<InternalInvocation> getTemplateSteps() throws TemplateNotCompatibleException, Exception {
        Map mapTemplateColumnToTable = this.getColumnMappingTemplateToTable(this.table);
        ArrayList<InternalInvocation> invocationList = new ArrayList<InternalInvocation>();
        for (TemplateColumn templateColumn : this.template.getColumns()) {
            invocationList.add(this.retrieveInvocation(templateColumn, mapTemplateColumnToTable));
        }
        invocationList.add(this.getInvocationForTableTypeChange());
        try {
            invocationList.add(this.getRuleInvocation());
        }
        catch (Exception e) {
            log.warn("rules not applicable to template", (Throwable)e);
        }
        ArrayList<InternalInvocation> invocationActions = new ArrayList<InternalInvocation>();
        for (TemplateAction action : this.template.getActions()) {
            log.debug("creating action " + action.getClass());
            Map mapping = action.replaceColumnReferences(this.table.getId(), mapTemplateColumnToTable);
            InternalInvocation invocation = this.createInvocationCouple(null, new OperationId(((Long)action.getIdentifier()).longValue()), this.operationFactories, mapping);
            if (action instanceof ColumnCreatorAction) {
                int index = 0;
                for (TemplateColumn column : ((ColumnCreatorAction)action).getCreatedColumns()) {
                    String newColumnId = InternalInvocation.getDinamicallyCreatedColumnId((String)invocation.getInvocationId(), (int)index++);
                    log.debug("template column ID is " + column.getId() + " and new column id is " + newColumnId);
                    mapTemplateColumnToTable.put(column.getId(), new ColumnDescriptor(new ColumnLocalId(newColumnId), column.getValueType()));
                }
            }
            if (action instanceof TemplateColumnAction) {
                ColumnLocalId changedColumnId = ((ColumnDescriptor)mapTemplateColumnToTable.get(((TemplateColumnAction)action).getColumnId())).getColumnId();
                log.debug("changing column id " + ((TemplateColumnAction)action).getColumnId() + " with " + changedColumnId.getValue());
                invocation.setColumnId(changedColumnId);
            }
            invocationActions.add(invocation);
        }
        invocationList.addAll(invocationActions);
        return invocationList;
    }

    private InternalInvocation retrieveInvocation(TemplateColumn<?> templateColumn, Map<String, ColumnDescriptor> mapTemplateColumnToTable) throws Exception {
        switch (1.$SwitchMap$org$gcube$data$analysis$tabulardata$commons$templates$model$columns$ColumnCategory[templateColumn.getColumnType().ordinal()]) {
            case 1: {
                return this.createInvocationCouple(mapTemplateColumnToTable.get(templateColumn.getId()).getColumnId(), changeToAttributeColumnTypeOperationID, this.operationFactories, this.simpleTypeParameterRetriever(templateColumn));
            }
            case 2: {
                DimensionReference dimRef = (DimensionReference)templateColumn.getReference();
                HashMap<String, ColumnReference> dimensionParameters = new HashMap<String, ColumnReference>();
                dimensionParameters.put(TARGET_COLUMN_PARAMETER, new ColumnReference(dimRef.getTableId(), dimRef.getColumnId()));
                InternalInvocation dimInvocation = this.createInvocationCouple(mapTemplateColumnToTable.get(templateColumn.getId()).getColumnId(), changeToDimensionColumnTypeOperationID, this.operationFactories, dimensionParameters);
                ColumnDescriptor dimDescriptor = new ColumnDescriptor(new ColumnLocalId(InternalInvocation.getDinamicallyCreatedColumnId((String)dimInvocation.getInvocationId(), (int)0)), IntegerType.class);
                mapTemplateColumnToTable.put(templateColumn.getId(), dimDescriptor);
                return dimInvocation;
            }
            case 3: {
                TimeDimensionReference periodReference = (TimeDimensionReference)templateColumn.getReference();
                HashMap<String, String> timeParameter = new HashMap<String, String>();
                if (periodReference.getFormatIdentifier() != null) {
                    timeParameter.put(INPUT_FORMAT_ID, periodReference.getFormatIdentifier());
                }
                timeParameter.put(PERIOD_FORMAT_PARAMETER_ID, periodReference.getPeriod().getName());
                InternalInvocation timeDimInvocation = this.createInvocationCouple(mapTemplateColumnToTable.get(templateColumn.getId()).getColumnId(), changeToTimeDimensionColumnTypeOperationID, this.operationFactories, timeParameter);
                ColumnDescriptor timeDescriptor = new ColumnDescriptor(new ColumnLocalId(InternalInvocation.getDinamicallyCreatedColumnId((String)timeDimInvocation.getInvocationId(), (int)0)), IntegerType.class);
                mapTemplateColumnToTable.put(templateColumn.getId(), timeDescriptor);
                return timeDimInvocation;
            }
            case 4: {
                return this.createInvocationCouple(mapTemplateColumnToTable.get(templateColumn.getId()).getColumnId(), changeToMeasureColumnTypeOperationID, this.operationFactories, this.simpleTypeParameterRetriever(templateColumn));
            }
            case 5: {
                LocaleReference reference = (LocaleReference)templateColumn.getReference();
                HashMap<String, DataLocaleMetadata> codeNameParams = new HashMap<String, DataLocaleMetadata>(1);
                codeNameParams.put("additionalMeta", new DataLocaleMetadata(reference.getLocale()));
                return this.createInvocationCouple(mapTemplateColumnToTable.get(templateColumn.getId()).getColumnId(), changeToCodeNameColumnTypeOperationID, this.operationFactories, codeNameParams);
            }
            case 6: {
                return this.createInvocationCouple(mapTemplateColumnToTable.get(templateColumn.getId()).getColumnId(), changeToCodeDescriptionColumnTypeOperationID, this.operationFactories);
            }
            case 7: {
                return this.createInvocationCouple(mapTemplateColumnToTable.get(templateColumn.getId()).getColumnId(), changeToAnnotationColumnTypeOperationID, this.operationFactories);
            }
            case 8: {
                return this.createInvocationCouple(mapTemplateColumnToTable.get(templateColumn.getId()).getColumnId(), changeToCodeColumnTypeOperationID, this.operationFactories);
            }
        }
        throw new RuntimeException("unexpected option");
    }

    public Map<String, Object> simpleTypeParameterRetriever(TemplateColumn<?> templateColumn) throws Exception {
        HashMap<String, Object> attributeParameters = new HashMap<String, Object>(2);
        attributeParameters.put(TARGET_DATA_TYPE_PARAMETER_ID, templateColumn.getValueType().newInstance());
        FormatReference formatReference = (FormatReference)templateColumn.getReference();
        if (formatReference != null) {
            attributeParameters.put(INPUT_FORMAT_ID, formatReference.getFormatIdentifier());
        }
        return attributeParameters;
    }

    public TemplateFinalActionExecutor getInvocationForFinalAction() {
        if (this.template.getAddToFlow() != null) {
            return this.tfaf.getExecutor(this.template);
        }
        return null;
    }

    private InternalInvocation createInvocationCouple(ColumnLocalId targetColumn, OperationId operationId, Factories operationFactories) {
        return this.createInvocationCouple(targetColumn, operationId, operationFactories, new HashMap(0));
    }

    private InternalInvocation createInvocationCouple(ColumnLocalId targetColumn, OperationId operationId, Factories operationFactories, Map<String, Object> parameter) {
        WorkerFactory factory = operationFactories.get(operationId);
        if (factory == null) {
            throw new RuntimeException("operation with id " + operationId + " not found");
        }
        InternalInvocation couple = new InternalInvocation(parameter, factory);
        couple.setColumnId(targetColumn);
        return couple;
    }

    private Map<String, ColumnDescriptor> getColumnMappingTemplateToTable(Table table) throws TemplateNotCompatibleException {
        List templateColumns = this.template.getColumns();
        List tableColumns = table.getColumns();
        HashMap<String, ColumnDescriptor> mapTemplateColumnToTable = new HashMap<String, ColumnDescriptor>();
        int templateIndex = 0;
        for (Column column : tableColumns) {
            if (column.getColumnType() instanceof IdColumnType || column.getColumnType() instanceof ValidationColumnType) continue;
            if (templateIndex >= templateColumns.size()) {
                throw new TemplateNotCompatibleException("the template specified is not compatible with the table " + table.getId().getValue());
            }
            mapTemplateColumnToTable.put(((TemplateColumn)templateColumns.get(templateIndex)).getId(), new ColumnDescriptor(column.getLocalId(), ((TemplateColumn)templateColumns.get(templateIndex)).getValueType()));
            ++templateIndex;
        }
        if (mapTemplateColumnToTable.size() != templateColumns.size()) {
            throw new TemplateNotCompatibleException("the template specified is not compatible with the table " + table.getId().getValue());
        }
        return mapTemplateColumnToTable;
    }

    private InternalInvocation getInvocationForTableTypeChange() {
        InternalInvocation changeTableTypeInvocation = null;
        switch (1.$SwitchMap$org$gcube$data$analysis$tabulardata$commons$templates$model$TemplateCategory[this.template.getCategory().ordinal()]) {
            case 1: {
                Map<String, String> codelistTypeParameter = Collections.singletonMap(TABLE_TYPE_PARAMETER_ID, new CodelistTableType().getName());
                changeTableTypeInvocation = this.createInvocationCouple(null, changeTableTypeOperationID, this.operationFactories, codelistTypeParameter);
                break;
            }
            case 2: {
                Map<String, String> datasetTypeParameter = Collections.singletonMap(TABLE_TYPE_PARAMETER_ID, new DatasetTableType().getName());
                changeTableTypeInvocation = this.createInvocationCouple(null, changeTableTypeOperationID, this.operationFactories, datasetTypeParameter);
                break;
            }
            default: {
                Map<String, String> genericTypeParameter = Collections.singletonMap(TABLE_TYPE_PARAMETER_ID, new GenericTableType().getName());
                changeTableTypeInvocation = this.createInvocationCouple(null, changeTableTypeOperationID, this.operationFactories, genericTypeParameter);
            }
        }
        return changeTableTypeInvocation;
    }
}

