/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cleaner;

import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.data.analysis.tabulardata.cleaner.GarbageCollector;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollector {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollector.class);
    private static final long timerPeriod = 600000L;
    private CubeManager cubeManager;
    private Timer timer;
    private GarbageCollectorTimer gbTimer = new GarbageCollectorTimer(this);

    protected GarbageCollector(CubeManager cubeManager) {
        this.cubeManager = cubeManager;
        this.timer = new Timer("GarbageCollector", true);
        this.timer.schedule((TimerTask)this.gbTimer, 600000L, 600000L);
        log.trace("GarbageCollector timer Started");
    }

    public void addTablesToRemove(Set<TableId> tables) {
        log.trace("table added for future removal : {}", tables);
        if (tables != null && tables.size() > 0) {
            this.gbTimer.addTableToRemove(tables);
        }
    }

    public void stop() {
        this.timer.cancel();
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ CubeManager access$1(GarbageCollector garbageCollector) {
        return garbageCollector.cubeManager;
    }
}

