/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.commons.webservice.HistoryManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.HistoryData;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.data.connection.unprivileged.Unprivileged;
import org.gcube.data.analysis.tabulardata.exceptions.NoSuchObjectException;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.gcube.data.analysis.tabulardata.utils.Util;
import org.gcube.data.analysis.tabulardata.weld.WeldService;
import org.slf4j.Logger;

@WebService(portName="HistoryManagerPort", serviceName="historymanager", targetNamespace="http://gcube-system.org/history", endpointInterface="org.gcube.data.analysis.tabulardata.commons.webservice.HistoryManager")
@Singleton
@WeldService
public class HistoryManagerImpl
implements HistoryManager {
    @Inject
    CubeManager cm;
    @Inject
    @Unprivileged
    DatabaseConnectionProvider databaseConnectionProvider;
    @Inject
    private EntityManagerHelper emHelper;
    @Inject
    Logger logger;

    public Table getLastTable(long tabularResourceId) throws NoSuchTabularResourceException, NoSuchTableException, InternalSecurityException {
        Table table;
        StorableTabularResource tabularResource;
        this.logger.info("requesting last table for tabularResource with id {} ", (Object)tabularResourceId);
        EntityManager entityManager = this.emHelper.getEntityManager();
        try {
            try {
                tabularResource = (StorableTabularResource)Util.getUserAuthorizedObject((Object)tabularResourceId, StorableTabularResource.class, (EntityManager)entityManager);
            }
            catch (NoSuchObjectException e) {
                throw new NoSuchTabularResourceException(tabularResourceId);
            }
            catch (InternalSecurityException e) {
                this.logger.error("error on authorization", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (entityManager != null && entityManager.isOpen()) {
                entityManager.close();
            }
        }
        if (tabularResource == null || !tabularResource.getScopes().contains(ScopeProvider.instance.get())) {
            this.logger.error("the tabular resource with id {} not exists", (Object)tabularResourceId);
            throw new NoSuchTabularResourceException(tabularResourceId);
        }
        if (tabularResource.getTableId() == null) {
            this.logger.debug("the tabular resource with id {} has empty history", (Object)tabularResourceId);
            return null;
        }
        try {
            table = this.cm.getTable(new TableId(tabularResource.getTableId().longValue()));
        }
        catch (Exception e) {
            this.logger.error("table not found");
            throw new NoSuchTableException(new TableId(tabularResource.getTableId().longValue()));
        }
        this.logger.info("returning table " + table);
        return table;
    }

    public List<HistoryData> getHistory(long tabularResourceId) throws NoSuchTabularResourceException, InternalSecurityException {
        StorableTabularResource tabularResource;
        EntityManager entityManager = this.emHelper.getEntityManager();
        try {
            try {
                tabularResource = (StorableTabularResource)Util.getUserAuthorizedObject((Object)tabularResourceId, StorableTabularResource.class, (EntityManager)entityManager);
            }
            catch (NoSuchObjectException e) {
                throw new NoSuchTabularResourceException(tabularResourceId);
            }
        }
        finally {
            if (entityManager != null && entityManager.isOpen()) {
                entityManager.close();
            }
        }
        if (tabularResource == null || !tabularResource.getScopes().contains(ScopeProvider.instance.get())) {
            this.logger.error("the tabular resource with id %s not exists", (Object)tabularResourceId);
            throw new NoSuchTabularResourceException(tabularResourceId);
        }
        List history = Util.toHistoryDataList((List)tabularResource.getHistorySteps());
        return history;
    }
}

